/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.table_def;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.Orm;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.annotation.OrmTable;
import org.nkjmlab.sorm4j.internal.util.StringCache;
import org.nkjmlab.sorm4j.util.table_def.annotation.AutoIncrement;
import org.nkjmlab.sorm4j.util.table_def.annotation.Check;
import org.nkjmlab.sorm4j.util.table_def.annotation.CheckConstraint;
import org.nkjmlab.sorm4j.util.table_def.annotation.Default;
import org.nkjmlab.sorm4j.util.table_def.annotation.Index;
import org.nkjmlab.sorm4j.util.table_def.annotation.IndexColumns;
import org.nkjmlab.sorm4j.util.table_def.annotation.NotNull;
import org.nkjmlab.sorm4j.util.table_def.annotation.PrimaryKey;
import org.nkjmlab.sorm4j.util.table_def.annotation.PrimaryKeyColumns;
import org.nkjmlab.sorm4j.util.table_def.annotation.Unique;
import org.nkjmlab.sorm4j.util.table_def.annotation.UniqueColumns;

@Experimental
public final class TableDefinition {
    private final String tableName;
    private final String tableNameAndColumnDefinitions;
    private final List<String> columnNames;
    private final String createTableStatement;
    private final String dropTableStatement;
    private final List<String> createIndexStatements;

    public static Builder builder(String tableName) {
        return new Builder(tableName);
    }

    public static Builder builder(Class<?> ormRecordClass) {
        Builder builder = TableDefinition.builder(TableDefinition.toTableName(ormRecordClass));
        Optional.ofNullable(ormRecordClass.getAnnotation(PrimaryKeyColumns.class)).map(a -> a.value()).ifPresent(val -> builder.setPrimaryKey((String)val));
        Optional.ofNullable((IndexColumns[])ormRecordClass.getAnnotationsByType(IndexColumns.class)).ifPresent(vals -> Arrays.stream(vals).forEach(v -> builder.addIndexDefinition(v.value())));
        Optional.ofNullable((UniqueColumns[])ormRecordClass.getAnnotationsByType(UniqueColumns.class)).ifPresent(vals -> Arrays.stream(vals).forEach(v -> builder.addUniqueConstraint(v.value())));
        Optional.ofNullable((CheckConstraint[])ormRecordClass.getAnnotationsByType(CheckConstraint.class)).ifPresent(vals -> Arrays.stream(vals).forEach(v -> builder.addCheckConstraint(v.value())));
        Annotation[][] parameterAnnotationsOfConstructor = TableDefinition.getCanonicalConstructor(ormRecordClass).map(constructor -> constructor.getParameterAnnotations()).orElse(null);
        Field[] fields = (Field[])Stream.of(ormRecordClass.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).toArray(Field[]::new);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            ArrayList<Object> opt = new ArrayList<Object>();
            opt.add(TableDefinition.toSqlDataType(field.getType()));
            LinkedHashSet anns = new LinkedHashSet();
            Arrays.stream(field.getAnnotations()).forEach(a -> anns.add(a));
            if (parameterAnnotationsOfConstructor != null) {
                Arrays.stream(parameterAnnotationsOfConstructor[i]).forEach(a -> anns.add(a));
            }
            for (Annotation ann : anns) {
                if (ann instanceof PrimaryKey) {
                    opt.add("primary key");
                    continue;
                }
                if (ann instanceof AutoIncrement) {
                    opt.add("auto_increment");
                    continue;
                }
                if (ann instanceof NotNull) {
                    opt.add("not null");
                    continue;
                }
                if (ann instanceof Index) {
                    builder.addIndexDefinition(StringCache.toUpperSnakeCase(field.getName()));
                    continue;
                }
                if (ann instanceof Unique) {
                    builder.addUniqueConstraint(StringCache.toUpperSnakeCase(field.getName()));
                    continue;
                }
                if (ann instanceof Check) {
                    opt.add("check (" + ((Check)ann).value() + ")");
                    continue;
                }
                if (!(ann instanceof Default)) continue;
                opt.add("default " + ((Default)ann).value());
            }
            builder.addColumnDefinition(StringCache.toUpperSnakeCase(field.getName()), (String[])opt.toArray(String[]::new));
        }
        return builder;
    }

    private static String toTableName(Class<?> ormRecordClass) {
        OrmTable ann = ormRecordClass.getAnnotation(OrmTable.class);
        if (ann == null || ann.value().length() == 0) {
            return StringCache.toUpperSnakeCase(ormRecordClass.getSimpleName() + "s");
        }
        return ann.value();
    }

    public static Optional<Constructor<?>> getCanonicalConstructor(Class<?> recordClass) {
        try {
            Class[] componentTypes = (Class[])Arrays.stream(recordClass.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).map(f -> f.getType()).toArray(Class[]::new);
            return Optional.of(recordClass.getDeclaredConstructor(componentTypes));
        }
        catch (NoSuchMethodException | SecurityException e) {
            return Optional.empty();
        }
    }

    private TableDefinition(String tableName, String tableSchema, List<String> columnNames, String createTableStatement, String dropTableStatement, List<String> createIndexStatements) {
        this.tableName = tableName;
        this.tableNameAndColumnDefinitions = tableSchema;
        this.columnNames = Collections.unmodifiableList(columnNames);
        this.createTableStatement = createTableStatement;
        this.dropTableStatement = dropTableStatement;
        this.createIndexStatements = Collections.unmodifiableList(createIndexStatements);
    }

    public String toString() {
        return "TableDefinition [tableName=" + this.tableName + ", tableNameAndColumnDefinitions=" + this.tableNameAndColumnDefinitions + ", columnNames=" + this.columnNames + ", createTableStatement=" + this.createTableStatement + ", dropTableStatement=" + this.dropTableStatement + ", createIndexStatements=" + this.createIndexStatements + "]";
    }

    public TableDefinition createIndexesIfNotExists(Orm orm) {
        this.getCreateIndexIfNotExistsStatements().forEach(s -> orm.executeUpdate((String)s, new Object[0]));
        return this;
    }

    public TableDefinition createTableIfNotExists(Orm orm) {
        orm.executeUpdate(this.getCreateTableIfNotExistsStatement(), new Object[0]);
        return this;
    }

    public TableDefinition dropTableIfExists(Orm orm) {
        orm.executeUpdate(this.getDropTableIfExistsStatement(), new Object[0]);
        return this;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<String> getCreateIndexIfNotExistsStatements() {
        return this.createIndexStatements;
    }

    public String getCreateTableIfNotExistsStatement() {
        return this.createTableStatement;
    }

    public String getDropTableIfExistsStatement() {
        return this.dropTableStatement;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableNameAndColumnDefinitions() {
        return this.tableNameAndColumnDefinitions;
    }

    public static String toSqlDataType(Class<?> type) {
        switch (type.getName()) {
            case "int": 
            case "java.lang.Integer": {
                return "integer";
            }
            case "double": 
            case "java.lang.Double": {
                return "double";
            }
            case "boolean": 
            case "java.lang.Boolean": {
                return "boolean";
            }
            case "byte": 
            case "java.lang.Byte": {
                return "tinyint";
            }
            case "short": 
            case "java.lang.Short": {
                return "smallint";
            }
            case "long": 
            case "java.lang.Long": {
                return "bigint";
            }
            case "float": 
            case "java.lang.Float": {
                return "float";
            }
            case "char": 
            case "java.lang.Character": {
                return "character";
            }
            case "java.lang.String": {
                return "varchar";
            }
            case "java.math.BigDecimal": {
                return "numeric";
            }
            case "java.util.Date": 
            case "java.sql.Timestamp": 
            case "java.time.Instant": 
            case "java.time.LocalDateTime": {
                return "timestamp";
            }
            case "java.sql.Time": 
            case "java.time.LocalTime": {
                return "time";
            }
            case "java.sql.Date": 
            case "java.time.LocalDate": {
                return "date";
            }
            case "java.time.OffsetTime": {
                return "time with time zone";
            }
            case "java.time.OffsetDateTime": {
                return "timestamp with time zone";
            }
            case "java.sql.Blob": {
                return "blob";
            }
            case "java.sql.Clob": {
                return "clob";
            }
            case "java.io.InputStream": {
                return "longvarbinary";
            }
            case "java.io.Reader": {
                return "longvarchar";
            }
            case "org.nkjmlab.sorm4j.util.h2.datatype.Json": {
                return "json";
            }
        }
        if (type.isArray()) {
            Class<?> compType = type.getComponentType();
            return TableDefinition.toSqlDataType(compType) + " array";
        }
        return "varchar";
    }

    public static class Builder {
        private String tableName;
        private final Map<String, String[]> columnDefinitions = new LinkedHashMap<String, String[]>();
        private String[] primaryKeys;
        private final List<String[]> uniqueColumnPairs = new ArrayList<String[]>();
        private final List<String[]> indexColumns = new ArrayList<String[]>();
        private final List<String> checkConditions = new ArrayList<String>();

        private static String createPrimaryKeyConstraint(String[] primaryKeys) {
            return primaryKeys == null || primaryKeys.length == 0 ? "" : ", primary key(" + String.join((CharSequence)", ", primaryKeys) + ")";
        }

        private static String createUniqueConstraint(List<String[]> uniqueColumnPairs) {
            return uniqueColumnPairs == null || uniqueColumnPairs.size() == 0 ? "" : ", " + String.join((CharSequence)", ", (CharSequence[])uniqueColumnPairs.stream().map(u -> "unique(" + String.join((CharSequence)", ", u) + ")").toArray(String[]::new));
        }

        private static String createCheckConstraint(List<String> checkConditions) {
            return checkConditions == null || checkConditions.size() == 0 ? "" : ", " + String.join((CharSequence)", ", (CharSequence[])checkConditions.stream().map(u -> "check(" + u + ")").toArray(String[]::new));
        }

        private static List<String> getColumunNames(Map<String, String[]> columnDefinitions) {
            return columnDefinitions.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
        }

        private static List<String> getColumuns(Map<String, String[]> columnDefinisions) {
            return columnDefinisions.keySet().stream().map(columnName -> columnName + " " + String.join((CharSequence)" ", Arrays.stream((String[])columnDefinisions.get(columnName)).map(s -> s.trim()).collect(Collectors.toList()))).collect(Collectors.toList());
        }

        private static String getCreateIndexOnStatement(String indexName, String tableName, String ... columns) {
            return "create index if not exists " + indexName + " on " + tableName + "(" + String.join((CharSequence)", ", columns) + ")";
        }

        private static String getTableSchema(String tableName, Map<String, String[]> columns, String[] primaryKeys, List<String[]> uniqueColumnPairs, List<String> checkConditions) {
            String schema = tableName + "(" + String.join((CharSequence)", ", Builder.getColumuns(columns)) + Builder.createPrimaryKeyConstraint(primaryKeys) + Builder.createUniqueConstraint(uniqueColumnPairs) + Builder.createCheckConstraint(checkConditions) + ")";
            return schema;
        }

        private static String[] toStringArray(Enum<?>[] enums) {
            return (String[])Arrays.stream(enums).map(e -> e.toString()).toArray(String[]::new);
        }

        private Builder(String tableName) {
            this.tableName = tableName;
        }

        public Builder addColumnDefinition(Enum<?> columnName, String ... dataTypeAndOptions) {
            this.addColumnDefinition(columnName.toString(), dataTypeAndOptions);
            return this;
        }

        public Builder addColumnDefinition(String columnName, String ... dataTypeAndOptions) {
            this.columnDefinitions.put(columnName, dataTypeAndOptions);
            return this;
        }

        public Builder addIndexDefinition(Enum<?> ... indexColumnPair) {
            this.addIndexDefinition(Builder.toStringArray(indexColumnPair));
            return this;
        }

        public Builder addIndexDefinition(String ... indexColumnPair) {
            this.indexColumns.add(indexColumnPair);
            return this;
        }

        public Builder addUniqueConstraint(Enum<?> ... uniqueColumnPair) {
            this.uniqueColumnPairs.add(Builder.toStringArray(uniqueColumnPair));
            return this;
        }

        public Builder addUniqueConstraint(String ... uniqueColumnPair) {
            this.uniqueColumnPairs.add(uniqueColumnPair);
            return this;
        }

        public Builder addCheckConstraint(String ... checkConditions) {
            this.checkConditions.addAll(Arrays.asList(checkConditions));
            return this;
        }

        public TableDefinition build() {
            if (this.columnDefinitions.isEmpty()) {
                return new TableDefinition(this.tableName, "", Collections.emptyList(), "", "", Collections.emptyList());
            }
            String tableSchema = Builder.getTableSchema(this.tableName, this.columnDefinitions, this.primaryKeys, this.uniqueColumnPairs, this.checkConditions);
            String createTableStatement = "create table if not exists " + tableSchema;
            String dropTableStatement = "drop table if exists " + this.tableName;
            return new TableDefinition(this.tableName, tableSchema, this.getColumunNames(), createTableStatement, dropTableStatement, this.getCreateIndexIfNotExistsStatements());
        }

        private List<String> getColumunNames() {
            return Builder.getColumunNames(this.columnDefinitions);
        }

        private List<String> getCreateIndexIfNotExistsStatements() {
            return this.indexColumns.stream().map(columns -> Builder.getCreateIndexOnStatement("index_in_" + this.tableName + "_on_" + String.join((CharSequence)"_", columns), this.tableName, columns)).collect(Collectors.toList());
        }

        public Builder setPrimaryKey(Enum<?> ... attributes) {
            this.setPrimaryKey(Builder.toStringArray(attributes));
            return this;
        }

        public Builder setPrimaryKey(String ... attributes) {
            this.primaryKeys = attributes;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }
    }
}

