/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.result;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;

public final class JdbcDatabaseMetaData {
    private final String databaseProductName;
    private final String databaseProductVersion;
    private final String driverName;
    private final String driverVersion;
    private final String url;
    private final String userName;
    private final String jdbcDriverVersion;
    private final int defaultTransactionIsolation;
    private final int maxConnections;
    private final String searchStringEscape;
    private final Map<String, JdbcTableMetaData> jdbcTablesMetaData;
    private final Map<String, Map<String, JdbcIndexMetaData>> jdbcIndexesMetaData;
    private final List<String> tableNames;

    public JdbcDatabaseMetaData(String databaseProductName, String databaseProductVersion, String driverName, String driverVersion, String jdbcDriverVersion, int defaultTransactionIsolation, int maxConnections, String url, String userName, String searchStringEscape, Map<String, JdbcTableMetaData> tables, Map<String, Map<String, JdbcIndexMetaData>> indexes) {
        this.databaseProductName = databaseProductName;
        this.databaseProductVersion = databaseProductVersion;
        this.driverName = driverName;
        this.driverVersion = driverVersion;
        this.jdbcDriverVersion = jdbcDriverVersion;
        this.defaultTransactionIsolation = defaultTransactionIsolation;
        this.maxConnections = maxConnections;
        this.url = url;
        this.userName = userName;
        this.searchStringEscape = searchStringEscape;
        this.jdbcTablesMetaData = tables;
        this.jdbcIndexesMetaData = indexes;
        this.tableNames = tables.keySet().stream().collect(Collectors.toList());
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String getSearchStringEscape() {
        return this.searchStringEscape;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getJdbcDriverVersion() {
        return this.jdbcDriverVersion;
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public Map<String, JdbcTableMetaData> getJdbcTablesMetaData() {
        return this.jdbcTablesMetaData;
    }

    public Map<String, Map<String, JdbcIndexMetaData>> getJdbcIndexesMetaData() {
        return this.jdbcIndexesMetaData;
    }

    public List<String> getTableNames() {
        return this.tableNames;
    }

    public String toString() {
        return "DatabaseMetaDataImpl [databaseProductName=" + this.databaseProductName + ", databaseProductVersion=" + this.databaseProductVersion + ", driverName=" + this.driverName + ", driverVersion=" + this.driverVersion + ", url=" + this.url + ", userName=" + this.userName + ", jdbcDriverVersion=" + this.jdbcDriverVersion + ", defaultTransactionIsolation=" + this.defaultTransactionIsolation + ", maxConnections=" + this.maxConnections + ", jdbcTablesMetaData=" + this.jdbcTablesMetaData + ", jdbcIndexesMetaData=" + this.jdbcIndexesMetaData + "]";
    }

    public static JdbcDatabaseMetaData of(DatabaseMetaData metaData) throws SQLException {
        try (ResultSet resultSet = metaData.getTables(null, "PUBLIC", null, new String[]{"TABLE", "VIEW"});){
            Map<String, JdbcTableMetaData> tables = JdbcDatabaseMetaData.mapColumnsInResultSetToMap(resultSet, List.of("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION")).stream().map(e -> new JdbcTableMetaData((Map<String, String>)e)).collect(Collectors.toMap(m -> m.get("TABLE_NAME"), m -> m, (v1, v2) -> v1));
            HashMap<String, Map<String, JdbcIndexMetaData>> indexes = new HashMap<String, Map<String, JdbcIndexMetaData>>();
            for (Map.Entry<String, JdbcTableMetaData> jdbcTableEntry : tables.entrySet()) {
                String tableName = jdbcTableEntry.getKey();
                ResultSet indexInfo = metaData.getIndexInfo(null, null, tableName, false, false);
                try {
                    Map<String, JdbcIndexMetaData> l = JdbcDatabaseMetaData.mapColumnsInResultSetToMap(indexInfo, List.of("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION")).stream().map(e -> new JdbcIndexMetaData((Map<String, String>)e)).collect(Collectors.toMap(m -> m.get("INDEX_NAME"), m -> m, (v1, v2) -> v1));
                    indexes.put(tableName, l);
                }
                finally {
                    if (indexInfo == null) continue;
                    indexInfo.close();
                }
            }
            JdbcDatabaseMetaData jdbcDatabaseMetaData = new JdbcDatabaseMetaData(metaData.getDatabaseProductName(), metaData.getDatabaseProductVersion(), metaData.getDriverName(), metaData.getDriverVersion(), ParameterizedStringUtils.newString("{}.{}", metaData.getJDBCMajorVersion(), metaData.getJDBCMinorVersion()), metaData.getDefaultTransactionIsolation(), metaData.getMaxConnections(), metaData.getURL(), metaData.getUserName(), metaData.getSearchStringEscape(), tables, indexes);
            return jdbcDatabaseMetaData;
        }
    }

    private static List<Map<String, String>> mapColumnsInResultSetToMap(ResultSet resultSet, List<String> columns) throws SQLException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        while (resultSet.next()) {
            Map index = columns.stream().collect(Collectors.toMap(col -> col, col -> {
                try {
                    String s = resultSet.getString((String)col);
                    return s != null ? s : "NULL";
                }
                catch (SQLException e) {
                    return "NA";
                }
            }, (v1, v2) -> v2, LinkedHashMap::new));
            result.add(index);
        }
        return result;
    }

    public static class JdbcIndexMetaData {
        private Map<String, String> map;

        public JdbcIndexMetaData(Map<String, String> map) {
            this.map = map;
        }

        public String get(String key) {
            return this.map.get(key);
        }

        public String toString() {
            return "JdbcIndexMetaData [map=" + this.map + "]";
        }
    }

    public static class JdbcTableMetaData {
        private Map<String, String> map;

        public JdbcTableMetaData(Map<String, String> map) {
            this.map = map;
        }

        public String get(String key) {
            return this.map.get(key);
        }

        public String toString() {
            return "JdbcTableMetaData [map=" + this.map + "]";
        }
    }
}

