/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.util.h2.sql.H2CsvFunctions;
import org.nkjmlab.sorm4j.util.h2.sql.H2CsvReadSql;
import org.nkjmlab.sorm4j.util.table_def.TableWithDefinition;

@Experimental
public interface H2Table<T>
extends TableWithDefinition<T> {
    default public H2CsvReadSql.Builder csvReadSqlBuilder(File csvFile) {
        return H2CsvReadSql.builder(csvFile, this.getValueType());
    }

    default public String getReadCsvWithHeaderSql(File csvFile, Charset charset, char separator) {
        H2CsvReadSql.Builder builder = this.csvReadSqlBuilder(csvFile).setCharset(charset).setFieldSeparator(separator);
        return builder.build().getCsvReadAndSelectSql();
    }

    default public List<T> readCsvWithHeader(File csvFile) {
        return this.readCsvWithHeader(csvFile, StandardCharsets.UTF_8, ',');
    }

    default public List<T> readCsvWithHeader(File csvFile, Charset charset, char separator) {
        try {
            return this.getOrm().readList(this.getValueType(), this.getReadCsvWithHeaderSql(csvFile, charset, separator), new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error occurs in: " + this.getReadCsvWithHeaderSql(csvFile, charset, separator), e);
        }
    }

    default public File writeCsv(File toFile) {
        return this.writeCsv(toFile, "select * from " + this.getTableName());
    }

    default public File writeCsv(File toFile, String selectSql) {
        this.getOrm().executeUpdate(H2CsvFunctions.getCallCsvWriteSql(toFile, selectSql, StandardCharsets.UTF_8, ','), new Object[0]);
        return toFile;
    }
}

