/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.result;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.nkjmlab.sorm4j.common.ConsumerHandler;
import org.nkjmlab.sorm4j.common.FunctionHandler;
import org.nkjmlab.sorm4j.context.PreparedStatementSupplier;
import org.nkjmlab.sorm4j.context.SormContext;
import org.nkjmlab.sorm4j.context.SqlParametersSetter;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.result.ResultSetIterator;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.result.ResultSetStream;
import org.nkjmlab.sorm4j.util.logger.LogPoint;
import org.nkjmlab.sorm4j.util.logger.LoggerContext;

abstract class AbstractResultSetStream<T>
implements ResultSetStream<T> {
    private final Class<T> objectClass;
    private final String sql;
    private final Object[] parameters;

    public AbstractResultSetStream(Class<T> objectClass, String sql, Object[] parameters) {
        this.objectClass = objectClass;
        this.sql = sql;
        this.parameters = parameters;
    }

    @Override
    public void accept(ConsumerHandler<Stream<T>> handler) {
        this.apply(stream -> {
            handler.accept((Stream)stream);
            return null;
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <R> R apply(OrmConnectionImpl ormConn, FunctionHandler<Stream<T>, R> handler) {
        SormContext context = ormConn.getContext();
        LoggerContext loggerContext = context.getLoggerContext();
        PreparedStatementSupplier statementSupplier = context.getPreparedStatementSupplier();
        SqlParametersSetter parametersSetter = context.getSqlParametersSetter();
        try (PreparedStatement stmt = statementSupplier.prepareStatement(ormConn.getJdbcConnection(), this.sql);){
            Object r;
            block14: {
                parametersSetter.setParameters(stmt, this.parameters);
                Optional<LogPoint> lp = loggerContext.createLogPoint(LoggerContext.Category.EXECUTE_QUERY, this.objectClass);
                lp.ifPresent(_lp -> _lp.logBeforeSql(ormConn.getJdbcConnection(), this.sql, this.parameters));
                ResultSet resultSet = stmt.executeQuery();
                try {
                    Stream<T> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(new ResultSetIterator<T>(ormConn, this.objectClass, resultSet), 16), false);
                    Object ret = handler.apply(stream);
                    lp.ifPresent(_lp -> _lp.logAfterQuery(ret));
                    r = ret;
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }
}

