/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.table.Table;
import org.nkjmlab.sorm4j.util.h2.sql.H2CsvFunctions;
import org.nkjmlab.sorm4j.util.h2.sql.H2CsvReadSql;

@Experimental
public interface H2Table<T>
extends Table<T> {
    default public H2CsvReadSql.Builder csvReadSqlBuilder(File csvFile) {
        return H2CsvReadSql.builder(csvFile, this.getValueType());
    }

    default public String getReadCsvWithHeaderSql(File csvFile, Charset charset, char fieldSeparator, Character fieldDelimiter) {
        H2CsvReadSql.Builder builder = this.csvReadSqlBuilder(csvFile).setCharset(charset).setFieldSeparator(fieldSeparator).setFieldDelimiter(fieldDelimiter);
        return builder.build().getCsvReadAndSelectSql();
    }

    default public List<T> readCsvWithHeader(File csvFile) {
        return this.readCsvWithHeader(csvFile, StandardCharsets.UTF_8, ',', null);
    }

    default public List<T> readCsvWithHeader(File csvFile, Charset charset, char fieldSeparator, Character fieldDelimiter) {
        try {
            return this.getOrm().readList(this.getValueType(), this.getReadCsvWithHeaderSql(csvFile, charset, fieldSeparator, fieldDelimiter), new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error occurs in: " + this.getReadCsvWithHeaderSql(csvFile, charset, fieldSeparator, fieldDelimiter), e);
        }
    }

    default public File writeCsv(File toFile) {
        return this.writeCsv(toFile, "select * from " + this.getTableName());
    }

    default public File writeCsv(File toFile, String selectSql) {
        return this.writeCsv(toFile, selectSql, StandardCharsets.UTF_8, ',', null);
    }

    default public File writeCsv(File toFile, String selectSql, Charset charset, char fieldSeparator, Character fieldDelimiter) {
        this.getOrm().executeUpdate(H2CsvFunctions.getCallCsvWriteSql(toFile, selectSql, charset, fieldSeparator, fieldDelimiter), new Object[0]);
        return toFile;
    }
}

