/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.context.SqlParameterSetter;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.util.datatype.OrmJsonColumnContainer;

@Experimental
public class JacksonSqlParameterSetter
implements SqlParameterSetter {
    private final ObjectMapper objectMapper;
    private final Map<Class<?>, Boolean> ormJsonContainer = new ConcurrentHashMap();

    public JacksonSqlParameterSetter(ObjectMapper objectMapper, Class<?> ... ormJsonColumnContainerClasses) {
        this.objectMapper = objectMapper;
        Arrays.stream(ormJsonColumnContainerClasses).forEach(c -> this.ormJsonContainer.put((Class<?>)c, true));
    }

    private boolean isOrmJsonContainer(Class<?> type) {
        return this.ormJsonContainer.computeIfAbsent(type, key -> ArrayUtils.getInternalComponentType(type).getAnnotation(OrmJsonColumnContainer.class) != null || List.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || this.ormJsonContainer.getOrDefault(ArrayUtils.getInternalComponentType(type), false) != false);
    }

    @Override
    public boolean test(PreparedStatement stmt, int parameterIndex, Object parameter) throws SQLException {
        return this.isOrmJsonContainer(parameter.getClass());
    }

    @Override
    public void setParameter(PreparedStatement stmt, int parameterIndex, Object parameter) throws SQLException {
        try {
            stmt.setBytes(parameterIndex, this.objectMapper.writeValueAsBytes(parameter));
        }
        catch (JsonProcessingException e) {
            throw Try.rethrow(e);
        }
    }
}

