/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util.logger;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nkjmlab.sorm4j.internal.util.MethodInvokerInfoUtils;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.internal.util.logger.AbstractSormLogger;
import org.nkjmlab.sorm4j.util.logger.SormLogger;

public final class Log4jSormLogger
extends AbstractSormLogger
implements SormLogger {
    public static final boolean enableLogger = Log4jSormLogger.isEnable();
    private final Logger logger;

    private static boolean isEnable() {
        return Try.getOrElse(() -> {
            Class.forName("org.apache.logging.log4j.Logger");
            return true;
        }, false);
    }

    public static SormLogger getLogger() {
        if (!enableLogger) {
            System.err.println("sorm4j: [org.apache.logging.log4j.Logger] is not found at the classpath.If you want to use Log4j2, you should add Log4j2 logger at the classpath.");
        }
        return new Log4jSormLogger(LogManager.getLogger());
    }

    Log4jSormLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void trace(String format, Object ... params) {
        this.printf(2, Level.TRACE, format, params);
    }

    @Override
    public void debug(String format, Object ... params) {
        this.printf(2, Level.DEBUG, format, params);
    }

    private void printf(int depth, Level level, String format, Object ... params) {
        this.logger.printf(level, "%n  " + MethodInvokerInfoUtils.getInvokerInfo(depth, new Throwable().getStackTrace()) + ParameterizedStringFormatter.LENGTH_256.format(format, params), new Object[0]);
    }

    @Override
    public void info(String format, Object ... params) {
        this.printf(2, Level.INFO, format, params);
    }

    @Override
    public void warn(String format, Object ... params) {
        this.printf(2, Level.WARN, format, params);
    }

    @Override
    public void error(String format, Object ... params) {
        this.printf(2, Level.ERROR, format, params);
    }

    @Override
    public void trace(int depth, String format, Object ... params) {
        this.printf(depth, Level.TRACE, format, params);
    }

    @Override
    public void debug(int depth, String format, Object ... params) {
        this.printf(depth, Level.DEBUG, format, params);
    }

    @Override
    public void info(int depth, String format, Object ... params) {
        this.printf(depth, Level.INFO, format, params);
    }

    @Override
    public void warn(int depth, String format, Object ... params) {
        this.printf(depth, Level.WARN, format, params);
    }

    @Override
    public void error(int depth, String format, Object ... params) {
        this.printf(depth, Level.ERROR, format, params);
    }
}

