/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.datasource;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.internal.util.SystemPropertyUtils;
import org.nkjmlab.sorm4j.internal.util.Try;

@Experimental
public class H2LocalDataSourceFactory {
    private final File databaseDirectory;
    private final String databaseName;
    private final String username;
    private final String password;
    private final String databasePath;
    private final String inMemoryModeJdbcUrl;
    private final String serverModeJdbcUrl;
    private final String embeddedModeJdbcUrl;
    private final String mixedModeJdbcUrl;

    private H2LocalDataSourceFactory(File databaseDirectory, String databaseName, String username, String password) {
        this.username = username;
        this.password = password;
        this.databaseName = databaseName;
        this.databaseDirectory = databaseDirectory;
        this.databasePath = this.createDatabasePath(databaseDirectory, databaseName);
        this.inMemoryModeJdbcUrl = "jdbc:h2:mem:" + databaseName + ";DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE";
        this.serverModeJdbcUrl = "jdbc:h2:tcp://localhost/" + this.databasePath;
        this.embeddedModeJdbcUrl = "jdbc:h2:file:" + this.databasePath;
        this.mixedModeJdbcUrl = "jdbc:h2:" + this.databasePath + ";AUTO_SERVER=TRUE";
    }

    private String createDatabasePath(File databaseDirectory, String databaseName) {
        String absolutePath;
        File dir = new File(absolutePath + ((absolutePath = databaseDirectory.getAbsolutePath().replace("\\", "/")).endsWith("/") ? "" : "/"));
        return new File(dir, databaseName).getAbsolutePath().replace("\\", "/");
    }

    private static String toUrlOption(String[] options) {
        if (options.length == 0) {
            return "";
        }
        return ";" + String.join((CharSequence)";", options);
    }

    public String getInMemoryModeJdbcUrl() {
        return this.getInMemoryModeJdbcUrl(new String[0]);
    }

    public String getServerModeJdbcUrl() {
        return this.getServerModeJdbcUrl(new String[0]);
    }

    public String getEmbeddedModeJdbcUrl() {
        return this.getEmbeddedModeJdbcUrl(new String[0]);
    }

    public String getMixedModeJdbcUrl() {
        return this.getMixedModeJdbcUrl(new String[0]);
    }

    public String getInMemoryModeJdbcUrl(String ... options) {
        return this.inMemoryModeJdbcUrl + H2LocalDataSourceFactory.toUrlOption(options);
    }

    public String getServerModeJdbcUrl(String ... options) {
        return this.serverModeJdbcUrl + H2LocalDataSourceFactory.toUrlOption(options);
    }

    public String getEmbeddedModeJdbcUrl(String ... options) {
        return this.embeddedModeJdbcUrl + H2LocalDataSourceFactory.toUrlOption(options);
    }

    public String getMixedModeJdbcUrl(String ... options) {
        return this.mixedModeJdbcUrl + H2LocalDataSourceFactory.toUrlOption(options);
    }

    public JdbcConnectionPool createInMemoryModeDataSource() {
        return JdbcConnectionPool.create((String)this.getInMemoryModeJdbcUrl(), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createServerModeDataSource() {
        return JdbcConnectionPool.create((String)this.getServerModeJdbcUrl(), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createEmbeddedModeDataSource() {
        return JdbcConnectionPool.create((String)this.getEmbeddedModeJdbcUrl(), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createMixedModeDataSource() {
        return JdbcConnectionPool.create((String)this.getMixedModeJdbcUrl(), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createInMemoryModeDataSource(String ... options) {
        return JdbcConnectionPool.create((String)this.getInMemoryModeJdbcUrl(options), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createServerModeDataSource(String ... options) {
        return JdbcConnectionPool.create((String)this.getServerModeJdbcUrl(options), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createEmbeddedModeDataSource(String ... options) {
        return JdbcConnectionPool.create((String)this.getEmbeddedModeJdbcUrl(options), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createMixedModeDataSource(String ... options) {
        return JdbcConnectionPool.create((String)this.getMixedModeJdbcUrl(options), (String)this.getUsername(), (String)this.getPassword());
    }

    public boolean makeFileDatabaseIfNotExists() {
        boolean bl;
        block10: {
            if (this.getDatabaseFile().exists()) {
                return false;
            }
            if (!this.databaseDirectory.exists()) {
                this.databaseDirectory.mkdirs();
            }
            Connection con = DriverManager.getConnection(this.getEmbeddedModeJdbcUrl(), this.getUsername(), this.getPassword());
            try {
                bl = true;
                if (con == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw Try.rethrow(e);
                }
            }
            con.close();
        }
        return bl;
    }

    public File getDatabaseFile() {
        return new File(this.databasePath + ".mv.db");
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public File getDatabaseDirectory() {
        return this.databaseDirectory;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabasePath() {
        return this.databasePath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(File databaseDirectory, String databaseName, String username, String password) {
        return new Builder(databaseDirectory, databaseName, username, password);
    }

    public String toString() {
        return "H2LocalDataSourceFactory [databaseDirectory=" + this.databaseDirectory + ", databaseName=" + this.databaseName + ", username=" + this.username + ", password=" + this.password + ", databasePath=" + this.databasePath + ", inMemoryModeJdbcUrl=" + this.inMemoryModeJdbcUrl + ", serverModeJdbcUrl=" + this.serverModeJdbcUrl + ", embeddedModeJdbcUrl=" + this.embeddedModeJdbcUrl + ", mixedModeJdbcUrl=" + this.mixedModeJdbcUrl + "]";
    }

    public static DataSource createTemporalInMemoryDataSource() {
        return JdbcConnectionPool.create((String)("jdbc:h2:mem:" + UUID.randomUUID().toString() + ";DB_CLOSE_DELAY=-1;"), (String)"", (String)"");
    }

    public static class Builder {
        private File databaseDirectory = new File(System.getProperty("java.io.tmpdir"));
        private String databaseName = "tmph2db";
        private String username = "";
        private String password = "";
        private static final Set<String> allowPrefixes = Set.of("~/", "~\\", "./", ".\\");

        public Builder() {
        }

        private Builder(File databaseDirectory, String dbName, String username, String password) {
            this.databaseName = dbName;
            this.username = username;
            this.password = password;
            this.setDatabaseDirectory(databaseDirectory);
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setDatabaseDirectory(File databaseDirectoryPath) {
            String prefix = databaseDirectoryPath.getPath().substring(0, 2);
            if (!allowPrefixes.contains(prefix) && !databaseDirectoryPath.isAbsolute()) {
                throw new IllegalArgumentException("the databaseDirectory path should be startWith " + allowPrefixes + " or absolute path. The given is [" + databaseDirectoryPath.getPath() + "]");
            }
            this.databaseDirectory = new File(SystemPropertyUtils.getTildeExpandAbsolutePath(databaseDirectoryPath));
            return this;
        }

        public Builder setDatabaseName(String dbName) {
            this.databaseName = dbName;
            return this;
        }

        public H2LocalDataSourceFactory build() {
            return new H2LocalDataSourceFactory(this.databaseDirectory, this.databaseName, this.username, this.password);
        }
    }
}

