/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.util.h2.server.H2ServerProperties;
import org.nkjmlab.sorm4j.util.logger.LoggerContext;
import org.nkjmlab.sorm4j.util.logger.SormLogger;

@Experimental
public abstract class H2ServerProcess {
    private static final SormLogger log = LoggerContext.getDefaultLoggerSupplier().get();
    static final long DEFAULT_TIMEOUT = Long.MAX_VALUE;
    static final TimeUnit DEFAULT_TIMEUNIT = TimeUnit.SECONDS;
    final H2ServerProperties properties;

    public H2ServerProcess(H2ServerProperties properties) {
        this.properties = properties;
    }

    public boolean awaitStart() {
        return this.awaitStart(Long.MAX_VALUE, DEFAULT_TIMEUNIT);
    }

    public boolean awaitStart(long timeout, TimeUnit unit) {
        return H2ServerProcess.awaitStartServer(this.properties, timeout, unit);
    }

    static boolean isActive(int port) {
        boolean bl;
        ServerSocket socket = new ServerSocket(port);
        try {
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        socket.close();
        return bl;
    }

    static boolean awaitStartServer(H2ServerProperties props, long timeout, TimeUnit unit) {
        if (H2ServerProcess.isActive(props.port)) {
            log.info("H2 {} server has been already active at http://localhost:{}", props.serverType, props.port);
            return true;
        }
        try {
            log.info("H2 {} Server will be start => {}", props.serverType, Stream.of(props.args).filter(arg -> !arg.equals(props.password)).collect(Collectors.toList()));
            ProcessBuilder pb = new ProcessBuilder(props.args);
            pb.redirectErrorStream(true);
            log.info("Wait up [{} {}] for H2 {} server starts at port {}.", new Object[]{timeout, unit, props.serverType, props.port});
            pb.start();
        }
        catch (IOException e) {
            throw Try.rethrow(e);
        }
        try {
            long start = System.currentTimeMillis();
            while (!H2ServerProcess.isActive(props.port)) {
                long durationInMillis = System.currentTimeMillis() - start;
                if (durationInMillis > TimeUnit.MICROSECONDS.convert(timeout, unit)) {
                    log.error("H2 server {} has not started yet.", props.serverType);
                    return false;
                }
                TimeUnit.SECONDS.sleep(1L);
            }
            log.info("[{} msec] H2 {} server is active at http://localhost:{}", System.currentTimeMillis() - start, props.serverType, props.port);
            return true;
        }
        catch (InterruptedException e) {
            throw Try.rethrow(e);
        }
    }
}

