/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.sql;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.util.h2.internal.H2Keyword;

public class CsvRead {
    private final String sql;

    public CsvRead(String sql) {
        this.sql = sql;
    }

    public String toString() {
        return this.sql;
    }

    private static String escape(String s) {
        return s.replace("\\", "\\\\").replace("\b", "\\b").replace("\t", "\\t").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("'", "\\'").replace("\"", "\\\"");
    }

    public static Builder builderForCsvWithHeader(File csvFile) {
        return new Builder().csvFile(csvFile);
    }

    public static Builder builderForCsvWithoutHeader(File csvFile, int csvColumnsCount) {
        return new Builder().csvFile(csvFile).columns(IntStream.range(0, csvColumnsCount).mapToObj(i -> "COL_" + i).toList());
    }

    static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> options = new TreeMap<String, String>();
        private File csvFile;
        private List<String> columns;

        public Builder columns(List<String> columns) {
            this.columns = columns;
            return this;
        }

        public Builder csvFile(File csvFile) {
            this.csvFile = csvFile;
            return this;
        }

        public Builder fieldSeparator(String val) {
            this.options.put("fieldSeparator", val);
            return this;
        }

        public Builder fieldDelimiter(String val) {
            this.options.put("fieldDelimiter", val);
            return this;
        }

        public Builder charset(String val) {
            this.options.put("charset", val);
            return this;
        }

        public CsvRead build() {
            String columnsString = this.columns == null ? null : String.join((CharSequence)this.options.getOrDefault("fieldSeparator", ","), this.columns);
            String optionsString = this.options.size() == 0 ? null : String.join((CharSequence)" ", this.options.entrySet().stream().map(en -> (String)en.getKey() + "=" + CsvRead.escape((String)en.getValue())).toList());
            List<String> l = Stream.of(H2Keyword.wrapSingleQuote(this.csvFile.getAbsolutePath().toString()), columnsString == null ? null : H2Keyword.wrapSingleQuote(columnsString), optionsString == null ? null : "stringdecode(" + H2Keyword.wrapSingleQuote(optionsString) + ")").toList();
            return new CsvRead("csvread (" + String.join((CharSequence)", ", l) + ")");
        }
    }
}

