/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.sql;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;
import org.nkjmlab.sorm4j.internal.util.StringCache;
import org.nkjmlab.sorm4j.util.h2.sql.CsvColumn;
import org.nkjmlab.sorm4j.util.h2.sql.H2CsvFunctions;
import org.nkjmlab.sorm4j.util.h2.sql.SkipCsvRead;
import org.nkjmlab.sorm4j.util.table_def.TableDefinition;

@Experimental
public class H2CsvReadSql {
    private final List<String> columns;
    private final String csvReadAndSelectSql;

    private H2CsvReadSql(List<String> columns, String csvReadAndSelectSql) {
        this.columns = columns;
        this.csvReadAndSelectSql = csvReadAndSelectSql;
    }

    public String getCsvReadAndInsertSql(String tableName) {
        return "insert into " + tableName + "(" + String.join((CharSequence)",", this.columns) + ") " + this.getCsvReadAndSelectSql();
    }

    public String getCsvReadAndSelectSql() {
        return this.csvReadAndSelectSql;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(File csvFile, Class<?> ormRecordClass) {
        return new Builder(csvFile, ormRecordClass);
    }

    public static Builder builder(File csvFile) {
        return new Builder(csvFile);
    }

    public static class Builder {
        private List<String> columns = new ArrayList<String>();
        private Map<String, String> aliases = new HashMap<String, String>();
        private List<String> csvColumns = new ArrayList<String>();
        private File csvFile;
        private Charset charset = StandardCharsets.UTF_8;
        private char fieldSeparator = (char)44;
        private Character fieldDelimiter = null;

        public Builder(File csvFile) {
            this.setCsvFile(csvFile);
        }

        public Builder(File csvFile, Class<?> ormRecordClass) {
            this(csvFile);
            this.setOrmRecordClass(ormRecordClass);
        }

        private Builder() {
        }

        public H2CsvReadSql build() {
            ArrayList<String> selectedColumns = new ArrayList<String>(this.columns);
            this.aliases.entrySet().forEach(en -> {
                int index = selectedColumns.indexOf(en.getKey());
                if (index == -1) {
                    Object[] params = new Object[]{en.getKey(), this.columns};
                    throw new IllegalStateException(ParameterizedStringFormatter.LENGTH_256.format("{} is not found in Columns {}", params));
                }
                selectedColumns.set(index, (String)en.getValue());
            });
            return new H2CsvReadSql(this.columns, H2CsvFunctions.getCsvReadAndSelectSql(selectedColumns, this.csvFile, this.csvColumns, this.charset, this.fieldSeparator, this.fieldDelimiter));
        }

        public Builder setCsvFile(File csvFile) {
            this.csvFile = csvFile;
            return this;
        }

        public Builder setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder setFieldSeparator(char fieldSeparator) {
            this.fieldSeparator = fieldSeparator;
            return this;
        }

        public Builder setFieldDelimiter(Character fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public Builder setCharset(String charset) {
            return this.setCharset(Charset.forName(charset));
        }

        public Builder setTableColumns(List<String> tableColumns) {
            this.columns = new ArrayList<String>(tableColumns);
            return this;
        }

        public Builder setTableColumns(String ... tableColumns) {
            return this.setTableColumns(Arrays.asList(tableColumns));
        }

        public Builder setCsvColumns(List<String> csvColumns) {
            this.csvColumns = new ArrayList<String>(csvColumns);
            return this;
        }

        public Builder setCsvColumns(String ... csvColumns) {
            return this.setCsvColumns(Arrays.asList(csvColumns));
        }

        public Builder mapCsvColumnToTableColumn(String expression, String column) {
            this.aliases.put(column, expression + " as " + column);
            return this;
        }

        public String toString() {
            return "Builder [columns=" + this.columns + ", aliases=" + this.aliases + ", csvColumns=" + this.csvColumns + ", csvFile=" + this.csvFile + ", charset=" + this.charset + ", fieldSeparator=" + this.fieldSeparator + ", fieldDelimiter=" + this.fieldDelimiter + "]";
        }

        public Builder setOrmRecordClass(Class<?> ormRecordClass) {
            Annotation[][] parameterAnnotationsOfConstructor = TableDefinition.getCanonicalConstructor(ormRecordClass).map(constructor -> constructor.getParameterAnnotations()).orElse(null);
            Field[] fields = (Field[])Stream.of(ormRecordClass.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).toArray(Field[]::new);
            ArrayList<Field> csvSkipColumns = new ArrayList<Field>();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                ArrayList<String> opt = new ArrayList<String>();
                opt.add(TableDefinition.toSqlDataType(field.getType()));
                LinkedHashSet anns = new LinkedHashSet();
                Arrays.stream(field.getAnnotations()).forEach(a -> anns.add(a));
                if (parameterAnnotationsOfConstructor != null) {
                    Arrays.stream(parameterAnnotationsOfConstructor[i]).forEach(a -> anns.add(a));
                }
                for (Annotation ann : anns) {
                    if (ann instanceof CsvColumn) {
                        this.mapCsvColumnToTableColumn(((CsvColumn)ann).value(), StringCache.toUpperSnakeCase(field.getName()));
                        continue;
                    }
                    if (!(ann instanceof SkipCsvRead)) continue;
                    csvSkipColumns.add(field);
                }
            }
            this.setTableColumns((String[])Stream.of(fields).map(f -> csvSkipColumns.contains(f) ? "null as " + StringCache.toUpperSnakeCase(f.getName()) : StringCache.toUpperSnakeCase(f.getName())).toArray(String[]::new));
            return this;
        }
    }
}

