/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.common;

import java.util.Objects;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;

public final class ColumnMetaData
implements Comparable<ColumnMetaData> {
    private final String msg;
    private final String typeName;
    private final int dataType;
    private final int ordinalPosition;
    private final String isAutoIncremented;
    private final String isNullable;
    private final String isGenerated;
    private final String name;

    public ColumnMetaData(String name, int dataType, String typeName, int ordinalPosition, String isNullable, String isAutoIncremented, String isGenerated) {
        this.name = name;
        this.typeName = typeName;
        this.dataType = dataType;
        this.ordinalPosition = ordinalPosition;
        this.isNullable = isNullable;
        this.isAutoIncremented = isAutoIncremented;
        this.isGenerated = isGenerated;
        Object[] params = new Object[]{String.format("%02d", this.getOrdinalPosition()), this.getName(), this.getTypeName(), this.getDataType(), this.getIsNullable(), this.getIsAutoIncremented(), this.getIsGenerated()};
        this.msg = ParameterizedStringFormatter.LENGTH_256.format("{{}: {} [{}({})] [n={},a={},g={}]}", params);
    }

    private int getDataType() {
        return this.dataType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public String getIsAutoIncremented() {
        return this.isAutoIncremented;
    }

    public String getIsNullable() {
        return this.isNullable;
    }

    public String getIsGenerated() {
        return this.isGenerated;
    }

    public String toString() {
        return this.msg;
    }

    @Override
    public int compareTo(ColumnMetaData o) {
        return this.name.compareTo(o.name);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.dataType, this.isAutoIncremented, this.isGenerated, this.isNullable, this.msg, this.name, this.ordinalPosition, this.typeName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColumnMetaData)) {
            return false;
        }
        ColumnMetaData other = (ColumnMetaData)obj;
        return this.dataType == other.dataType && Objects.equals(this.isAutoIncremented, other.isAutoIncremented) && Objects.equals(this.isGenerated, other.isGenerated) && Objects.equals(this.isNullable, other.isNullable) && Objects.equals(this.msg, other.msg) && Objects.equals(this.name, other.name) && this.ordinalPosition == other.ordinalPosition && Objects.equals(this.typeName, other.typeName);
    }
}

