/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.Map;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.internal.util.Try;

public final class ClassUtils {
    private static final Map<Class<?>, Class<?>> primitiveToWrapperMap = Map.ofEntries(Map.entry(Boolean.TYPE, Boolean.class), Map.entry(Byte.TYPE, Byte.class), Map.entry(Character.TYPE, Character.class), Map.entry(Short.TYPE, Short.class), Map.entry(Integer.TYPE, Integer.class), Map.entry(Long.TYPE, Long.class), Map.entry(Double.TYPE, Double.class), Map.entry(Float.TYPE, Float.class));
    private static final Map<Class<?>, Class<?>> wrapperToPrimitiveMap = primitiveToWrapperMap.entrySet().stream().collect(Collectors.toMap(en -> (Class)en.getValue(), en -> (Class)en.getKey()));

    private ClassUtils() {
    }

    public static Class<?> primitiveToWrapper(Class<?> clazz) {
        return primitiveToWrapperMap.get(clazz);
    }

    public static Class<?> wrapperToPrimitive(Class<?> clazz) {
        return wrapperToPrimitiveMap.get(clazz);
    }

    public static Class<?> convertToClass(String className) {
        switch (className) {
            case "java.lang.Boolean": {
                return Boolean.class;
            }
            case "java.lang.Character": {
                return Character.class;
            }
            case "java.lang.Byte": {
                return Byte.class;
            }
            case "java.lang.Short": {
                return Short.class;
            }
            case "java.lang.Integer": {
                return Integer.class;
            }
            case "java.lang.Long": {
                return Long.class;
            }
            case "java.lang.Float": {
                return Float.class;
            }
            case "java.lang.Double": {
                return Double.class;
            }
            case "java.lang.Object": {
                return Object.class;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw Try.rethrow(e);
        }
    }
}

