/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ConcurrentCache<K, V>
extends ConcurrentHashMap<K, V> {
    private final int maxSize;

    public ConcurrentCache(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public V put(K key, V value) {
        if (this.size() >= this.maxSize) {
            this.clear();
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (this.size() >= this.maxSize || m.size() + this.size() > this.maxSize) {
            this.clear();
        }
        super.putAll(m.entrySet().stream().limit(this.maxSize - this.size()).collect(Collectors.toMap(e -> e.getKey(), e -> e.getValue())));
    }
}

