/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.functions.system;

import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.util.h2.grammar.CsvOptions;
import org.nkjmlab.sorm4j.util.h2.internal.LiteralUtils;

@Experimental
public class CsvWrite {
    private final String sql;

    public CsvWrite(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public String toString() {
        return this.sql;
    }

    public static Builder builder(File file) {
        return new Builder().file(file);
    }

    static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private File file;
        private String query;
        private final CsvOptions.Builder csvOptionsBuilder = new CsvOptions.Builder();

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder file(File file) {
            this.file = file;
            return this;
        }

        public Builder caseSensitiveColumnNames(String val) {
            this.csvOptionsBuilder.caseSensitiveColumnNames(val);
            return this;
        }

        public Builder charset(String val) {
            this.csvOptionsBuilder.charset(val);
            return this;
        }

        public Builder escape(String val) {
            this.csvOptionsBuilder.escape(val);
            return this;
        }

        public Builder fieldDelimiter(String val) {
            this.csvOptionsBuilder.fieldDelimiter(val);
            return this;
        }

        public Builder fieldSeparator(String val) {
            this.csvOptionsBuilder.fieldSeparator(val);
            return this;
        }

        public Builder lineComment(String val) {
            this.csvOptionsBuilder.lineComment(val);
            return this;
        }

        public Builder lineSeparator(String val) {
            this.csvOptionsBuilder.lineSeparator(val);
            return this;
        }

        public Builder nullString(String val) {
            this.csvOptionsBuilder.nullString(val);
            return this;
        }

        public Builder quotedNulls(String val) {
            this.csvOptionsBuilder.quotedNulls(val);
            return this;
        }

        public Builder preserveWhitespace(String val) {
            this.csvOptionsBuilder.preserveWhitespace(val);
            return this;
        }

        public Builder writeColumnHeader(String val) {
            this.csvOptionsBuilder.writeColumnHeader(val);
            return this;
        }

        public CsvWrite build() {
            CsvOptions csvOptions = this.csvOptionsBuilder.build();
            List<String> l = Stream.of(LiteralUtils.wrapSingleQuote(this.file.getAbsolutePath().toString()), LiteralUtils.wrapSingleQuote(this.query), csvOptions == null || csvOptions.getSql() == null ? null : "stringdecode(" + LiteralUtils.wrapSingleQuote(csvOptions.getSql()) + ")").toList();
            return new CsvWrite("csvwrite(" + String.join((CharSequence)", ", l) + ")");
        }
    }
}

