/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.grammar;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.nkjmlab.sorm4j.util.h2.internal.LiteralUtils;

public class ScriptCompressionEncryption {
    private final String sql;

    public ScriptCompressionEncryption(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public static Builder defaultBuilder(String password) {
        return new Builder().compression("DEFLATE").cipher("AES").password(password);
    }

    public static class Builder {
        private final Map<String, String> props = new LinkedHashMap<String, String>();

        private void procProp(String key, BiConsumer<String, String> func) {
            String val = this.props.get(key);
            if (val == null) {
                return;
            }
            func.accept(key, val);
        }

        public Builder compression(String compression) {
            this.props.put("compression", compression);
            return this;
        }

        public Builder cipher(String cipher) {
            this.props.put("cipher", cipher);
            return this;
        }

        public Builder password(String password) {
            this.props.put("password", password);
            return this;
        }

        public ScriptCompressionEncryption build() {
            ArrayList ret = new ArrayList();
            this.procProp("compression", (key, val) -> ret.add(key + " " + val));
            this.procProp("cipher", (key, val) -> ret.add(key + " " + val));
            this.procProp("password", (key, val) -> ret.add(key + " " + LiteralUtils.wrapSingleQuote(val)));
            return new ScriptCompressionEncryption(String.join((CharSequence)" ", ret));
        }
    }
}

