/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.server;

import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.h2.tools.Server;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.util.h2.server.H2ServerProcess;
import org.nkjmlab.sorm4j.util.h2.server.H2TcpServerProperties;
import org.nkjmlab.sorm4j.util.logger.LoggerContext;
import org.nkjmlab.sorm4j.util.logger.SormLogger;

@Experimental
public class H2TcpServerProcess
extends H2ServerProcess {
    private static final SormLogger log = LoggerContext.getDefaultLoggerSupplier().get();

    public H2TcpServerProcess(H2TcpServerProperties properties) {
        super(properties);
    }

    public boolean awaitShutdown() {
        return this.awaitShutdown(Long.MAX_VALUE, DEFAULT_TIMEUNIT);
    }

    public boolean awaitShutdown(long timeout, TimeUnit unit) {
        return H2TcpServerProcess.awaitShutdownTcpServer((H2TcpServerProperties)this.properties, timeout, unit);
    }

    private static boolean awaitShutdownTcpServer(H2TcpServerProperties props, long timeout, TimeUnit unit) {
        if (!H2TcpServerProcess.isActive(props.port)) {
            log.info("H2 TCP server is not active at {}.", props.port);
            return true;
        }
        try {
            log.info("Wait up [{} {}] for H2 {} server shutdowns at port {}.", new Object[]{timeout, unit, props.serverType, props.port});
            Server.shutdownTcpServer((String)("tcp://localhost:" + props.port), (String)props.password, (boolean)false, (boolean)false);
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
        try {
            long start = System.currentTimeMillis();
            while (H2TcpServerProcess.isActive(props.port)) {
                long durationInMilli = System.currentTimeMillis() - start;
                if (durationInMilli > TimeUnit.MICROSECONDS.convert(timeout, unit)) {
                    log.warn("H2 TCP server is still active.", new Object[0]);
                    return false;
                }
                TimeUnit.SECONDS.sleep(1L);
            }
        }
        catch (InterruptedException e) {
            throw Try.rethrow(e);
        }
        log.info("H2 TCP server is not active.", new Object[0]);
        return true;
    }
}

