/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.util.h2.server.H2ServerProperties;
import org.nkjmlab.sorm4j.util.h2.server.H2ServerPropertiesBuilder;

@Experimental
public class H2TcpServerProperties
extends H2ServerProperties {
    public H2TcpServerProperties(String serverType, int port, String password, String[] args) {
        super(serverType, port, password, args);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends H2ServerPropertiesBuilder<Builder> {
        private static final int DEFAULT_TCP_PORT = 9092;

        public Builder() {
            super("TCP", 9092, "");
        }

        @Override
        public H2TcpServerProperties build() {
            ArrayList<String> args = new ArrayList<String>(List.of(this.javaCommand, "-cp", this.getH2ClassPath(), "org.h2.tools.Server"));
            args.addAll(List.of("-tcp", "-tcpPort", "" + this.port));
            args.addAll(Arrays.asList(this.options));
            args.add("-tcpPassword");
            args.add(this.password);
            return new H2TcpServerProperties(this.serverType, this.port, this.password, (String[])args.toArray(String[]::new));
        }

        @Override
        public Builder getThisBuilder() {
            return this;
        }
    }
}

