package org.nkjmlab.sorm4j.context;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import org.nkjmlab.sorm4j.common.ColumnMetaData;

public interface TableMetaDataParser {
  /**
   * Retrieves a list of auto-generated columns of the given table name from the database metadata.
   *
   * @param metaData
   * @param tableName
   * @return
   * @throws SQLException
   */
  List<String> getAutoGeneratedColumns(DatabaseMetaData metaData, String tableName)
      throws SQLException;

  /**
   * Gets a list of column metadata in the given table.
   *
   * @param metaData
   * @param tableName
   * @return
   * @throws SQLException
   */
  List<ColumnMetaData> getColumnsMetaData(DatabaseMetaData metaData, String tableName)
      throws SQLException;

  /**
   * Retrieves a list of primary keys columns of the given table name from the database metadata.
   *
   * @param metaData
   * @param tableName
   * @return
   * @throws SQLException
   */
  List<String> getPrimaryKeys(DatabaseMetaData metaData, String tableName) throws SQLException;
}
