/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping.multirow;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import org.nkjmlab.sorm4j.context.PreparedStatementSupplier;
import org.nkjmlab.sorm4j.context.SqlParametersSetter;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.mapping.SqlParametersToTableMapping;
import org.nkjmlab.sorm4j.internal.mapping.multirow.BatchHelper;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.util.logger.LoggerContext;

public final class BatchOfMultiRowInOneStatementProcessor<T>
extends MultiRowProcessor<T> {
    private final int multiRowSize;
    private final int batchSizeWithMultiRow;

    public BatchOfMultiRowInOneStatementProcessor(LoggerContext loggerContext, SqlParametersSetter sqlParametersSetter, PreparedStatementSupplier statementSupplier, SqlParametersToTableMapping<T> tableMapping, int batchSize, int multiRowSize, int batchSizeWithMultiRow) {
        super(loggerContext, sqlParametersSetter, statementSupplier, tableMapping, batchSize);
        this.multiRowSize = multiRowSize;
        this.batchSizeWithMultiRow = batchSizeWithMultiRow;
    }

    @Override
    public final int[] multiRowInsert(Connection con, T[] objects) {
        return this.execMultiRowProcIfValidObjects(con, objects, nonNullObjects -> this.procMultiRowOneStatementAndBatch(con, num -> this.prepareStatement(con, this.getSql().getMultirowInsertSql((int)num)), (stmt, objs) -> this.setPrametersOfMultiRow((PreparedStatement)stmt, (T[])objs), (T[])nonNullObjects));
    }

    @Override
    public final int[] multiRowMerge(Connection con, T[] objects) {
        return this.execMultiRowProcIfValidObjects(con, objects, nonNullObjects -> this.procMultiRowOneStatementAndBatch(con, num -> this.prepareStatement(con, this.getSql().getMultirowMergeSql((int)num)), (stmt, objs) -> this.setPrametersOfMultiRow((PreparedStatement)stmt, (T[])objs), (T[])nonNullObjects));
    }

    private final int[] procMultiRowOneStatementAndBatch(Connection con, Try.ThrowableFunction<Integer, PreparedStatement> multiRowStatementCreator, Try.ThrowableBiConsumer<PreparedStatement, T[]> parametersSetter, T[] objects) {
        List<T[]> objsPartitions = ArrayUtils.split(this.multiRowSize, objects);
        int[] result = new int[objsPartitions.size()];
        boolean origAutoCommit = OrmConnectionImpl.getAutoCommit(con);
        try {
            int[] nArray;
            block19: {
                OrmConnectionImpl.setAutoCommit(con, false);
                try (PreparedStatement stmt = multiRowStatementCreator.apply(this.multiRowSize);){
                    BatchHelper helper = new BatchHelper(this.batchSizeWithMultiRow, stmt);
                    for (int partitionNum = 0; partitionNum < objsPartitions.size() - 1; ++partitionNum) {
                        T[] objectsInOnePartition = objsPartitions.get(partitionNum);
                        parametersSetter.accept(stmt, objectsInOnePartition);
                        helper.addBatchAndExecuteIfReachedThreshold();
                    }
                    int[] firstResult = helper.finish();
                    System.arraycopy(firstResult, 0, result, 0, firstResult.length);
                }
                int lastPartition = objsPartitions.size() - 1;
                T[] objectsInLastPartition = objsPartitions.get(lastPartition);
                PreparedStatement lastStmt = multiRowStatementCreator.apply(objectsInLastPartition.length);
                try {
                    parametersSetter.accept(lastStmt, objectsInLastPartition);
                    result[lastPartition] = lastStmt.executeUpdate();
                    nArray = result;
                    if (lastStmt == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (lastStmt != null) {
                            try {
                                lastStmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        throw Try.rethrow(e);
                    }
                }
                lastStmt.close();
            }
            return nArray;
        }
        finally {
            OrmConnectionImpl.commitOrRollback(con, origAutoCommit);
            OrmConnectionImpl.setAutoCommit(con, origAutoCommit);
        }
    }
}

