/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.sql;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.nkjmlab.sorm4j.common.SormException;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;
import org.nkjmlab.sorm4j.sql.ParameterizedSql;
import org.nkjmlab.sorm4j.util.sql.SelectSql;

public final class ParameterizedSqlImpl
implements ParameterizedSql {
    private final String sql;
    private final Object[] parameters;
    private static final String EMBEDDED_PLACEHOLDER = "{?}";
    private static final String LIST_PLACEHOLDER = "<?>";

    private ParameterizedSqlImpl(String sql, Object ... parameters) {
        this.sql = sql;
        this.parameters = parameters;
    }

    public String toString() {
        return "sql=[" + this.sql + "]" + (String)(this.parameters == null || this.parameters.length == 0 ? "" : ", parameters=" + Arrays.toString(this.parameters));
    }

    @Override
    public final String getSql() {
        return this.sql;
    }

    @Override
    public final Object[] getParameters() {
        return this.parameters;
    }

    public static ParameterizedSql of(String sql, Object ... parameters) {
        return new ParameterizedSqlImpl(sql, parameters);
    }

    public static ParameterizedSql parse(String sql, Object ... parameters) {
        if (parameters.length == 0) {
            return new ParameterizedSqlImpl(sql, parameters);
        }
        ParameterizedSql embeddedSql = sql.contains(EMBEDDED_PLACEHOLDER) ? ParameterizedSqlImpl.parseEmbeddedPlaceholder(sql, parameters) : new ParameterizedSqlImpl(sql, parameters);
        return sql.contains(LIST_PLACEHOLDER) ? ParameterizedSqlImpl.parseListPlaceholder(embeddedSql.getSql(), embeddedSql.getParameters()) : embeddedSql;
    }

    private static ParameterizedSql parseListPlaceholder(String sql, Object[] parameters) {
        List<Integer> specialParameterIndexes = ParameterizedSqlImpl.createSpecialParameterIndexes(sql, '<', '?', '>');
        ArrayList<Object> flattenListParams = new ArrayList<Object>();
        for (int i = 0; i < parameters.length; ++i) {
            if (specialParameterIndexes.contains(i)) {
                Object o = parameters[i];
                if (o instanceof Collection) {
                    ((Collection)o).forEach(p -> flattenListParams.add(p));
                    continue;
                }
                if (o.getClass().isArray()) {
                    int length = Array.getLength(o);
                    for (int j = 0; j < length; ++j) {
                        Object elem = Array.get(o, j);
                        flattenListParams.add(elem);
                    }
                    continue;
                }
                throw new SormException("<?> parameter should be bind Collection or Array");
            }
            flattenListParams.add(parameters[i]);
        }
        String _sql = ParameterizedStringFormatter.newString(sql, LIST_PLACEHOLDER, specialParameterIndexes.size(), index -> {
            int parameterLength = ParameterizedSqlImpl.getSize(parameters[(Integer)specialParameterIndexes.get((int)index)]);
            return "?,".repeat(parameterLength).substring(0, 2 * parameterLength - 1);
        });
        return new ParameterizedSqlImpl(_sql, flattenListParams.toArray());
    }

    private static int getSize(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        throw new SormException("<?> parameter should be bind Collection or Array");
    }

    public static ParameterizedSql parseEmbeddedPlaceholder(String sql, Object ... parameters) {
        List<Integer> specialParameterIndexes = ParameterizedSqlImpl.createSpecialParameterIndexes(sql, '{', '?', '}');
        ArrayList<Object> removedEmbeddedParams = new ArrayList<Object>();
        for (int i = 0; i < parameters.length; ++i) {
            if (specialParameterIndexes.contains(i)) continue;
            removedEmbeddedParams.add(parameters[i]);
        }
        String _sql = ParameterizedStringFormatter.newString(sql, EMBEDDED_PLACEHOLDER, specialParameterIndexes.size(), index -> parameters[(Integer)specialParameterIndexes.get((int)index)] == null ? "null" : parameters[(Integer)specialParameterIndexes.get((int)index)].toString());
        return new ParameterizedSqlImpl(_sql, removedEmbeddedParams.toArray());
    }

    private static List<Integer> createSpecialParameterIndexes(String str, char prefix, char normalPlaceholder, char suffix) {
        char[] arry = str.toCharArray();
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int parameterIndex = 0;
        for (int i = 0; i < arry.length; ++i) {
            char c = arry[i];
            if (c == normalPlaceholder && i - 1 >= 0 && arry[i - 1] == prefix && i + 1 < arry.length && arry[i + 1] == suffix) {
                ret.add(parameterIndex);
                ++parameterIndex;
                continue;
            }
            if (c != normalPlaceholder) continue;
            ++parameterIndex;
        }
        return ret;
    }

    @Override
    public String getBindedSql() {
        String sql = this.sql;
        for (int i = 0; i < this.parameters.length; ++i) {
            sql = sql.replaceFirst("\\?", SelectSql.literal(this.parameters[i]));
        }
        return sql;
    }
}

