/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.nkjmlab.sorm4j.util.h2.grammar.ScriptCompressionEncryption;
import org.nkjmlab.sorm4j.util.h2.internal.LiteralUtils;

public class ScriptSql {
    private final String sql;

    public ScriptSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean noData = null;
        private Boolean simple = null;
        private Boolean columns = null;
        private Boolean noPasswords = null;
        private Boolean noSettings = null;
        private Boolean drop = null;
        private Integer blockSize = null;
        private File fileName = null;
        private ScriptCompressionEncryption scriptCompressionEncryption = null;
        private String charset = null;
        private List<String> tables = new ArrayList<String>();
        private List<String> schemas = new ArrayList<String>();

        public Builder noData() {
            this.noData = true;
            return this;
        }

        public Builder simple() {
            this.simple = true;
            return this;
        }

        public Builder columns() {
            this.columns = true;
            return this;
        }

        public Builder noPasswords() {
            this.noPasswords = true;
            return this;
        }

        public Builder noSettings() {
            this.noSettings = true;
            return this;
        }

        public Builder drop(boolean drop) {
            this.drop = drop;
            return this;
        }

        public Builder blockSize(int blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder to(File fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder scriptCompressionEncryption(ScriptCompressionEncryption scriptCompressionEncryption) {
            this.scriptCompressionEncryption = scriptCompressionEncryption;
            return this;
        }

        public Builder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public Builder addTable(String table) {
            this.tables.add(table);
            return this;
        }

        public Builder addSchema(String schema) {
            this.schemas.add(schema);
            return this;
        }

        public ScriptSql build() {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("script");
            Optional.ofNullable(this.noData).filter(b -> b).ifPresent(c -> ret.add("nodata"));
            Optional.ofNullable(this.simple).ifPresent(c -> ret.add("simple"));
            Optional.ofNullable(this.columns).filter(b -> b).ifPresent(c -> ret.add("columns"));
            Optional.ofNullable(this.noPasswords).filter(b -> b).ifPresent(c -> ret.add("noPasswords"));
            Optional.ofNullable(this.noSettings).filter(b -> b).ifPresent(c -> ret.add("noSettings"));
            Optional.ofNullable(this.drop).filter(b -> b).ifPresent(c -> ret.add("drop"));
            Optional.ofNullable(this.blockSize).filter(b -> b != null).ifPresent(c -> ret.add("blocksize " + this.blockSize));
            if (this.fileName != null) {
                ret.add("to");
                ret.add(LiteralUtils.wrapSingleQuote(this.fileName.getAbsolutePath()));
                if (this.scriptCompressionEncryption != null) {
                    ret.add(this.scriptCompressionEncryption.getSql());
                }
                if (this.charset != null) {
                    ret.add("charset");
                    ret.add(LiteralUtils.wrapSingleQuote(this.charset));
                }
            }
            if (this.tables.size() != 0) {
                ret.add("table");
                ret.add(String.join((CharSequence)",", this.tables));
            }
            if (this.schemas.size() != 0) {
                ret.add("schema");
                ret.add(String.join((CharSequence)",", this.schemas));
            }
            return new ScriptSql(String.join((CharSequence)" ", ret));
        }
    }
}

