/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.commands;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;
import org.nkjmlab.sorm4j.internal.util.StringCache;
import org.nkjmlab.sorm4j.util.h2.commands.annotation.CsvColumn;
import org.nkjmlab.sorm4j.util.h2.commands.annotation.SkipCsvRead;
import org.nkjmlab.sorm4j.util.h2.functions.table.CsvRead;
import org.nkjmlab.sorm4j.util.table_def.TableDefinition;

@Experimental
public class SelectCsvReadSql {
    private final List<String> tableColumns;
    private final String sql;

    private SelectCsvReadSql(String sql, List<String> tableColumns) {
        this.tableColumns = tableColumns;
        this.sql = sql;
    }

    public List<String> getSelectColumns() {
        return this.tableColumns;
    }

    public String getSql() {
        return this.sql;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CsvRead csvRead) {
        return new Builder(csvRead);
    }

    public static Builder builder(CsvRead csvRead, Class<?> valueType) {
        return new Builder(csvRead, valueType);
    }

    public static class Builder {
        private List<String> tableColumns = new ArrayList<String>();
        private Map<String, String> aliases = new HashMap<String, String>();
        private CsvRead csvRead = null;

        public Builder(CsvRead csvRead) {
            this.csvRead(csvRead);
        }

        public Builder(CsvRead csvRead, Class<?> valueType) {
            this(csvRead);
            this.valueType(valueType);
        }

        private Builder() {
        }

        public SelectCsvReadSql build() {
            ArrayList<String> selectedColumns = new ArrayList<String>(this.tableColumns);
            this.aliases.entrySet().forEach(en -> {
                int index = selectedColumns.indexOf(en.getKey());
                if (index == -1) {
                    Object[] params = new Object[]{en.getKey(), this.tableColumns};
                    throw new IllegalStateException(ParameterizedStringFormatter.LENGTH_256.format("{} is not found in Columns {}", params));
                }
                selectedColumns.set(index, (String)en.getValue());
            });
            return new SelectCsvReadSql("select " + (selectedColumns == null || selectedColumns.size() == 0 ? "*" : String.join((CharSequence)",", selectedColumns)) + " from " + this.csvRead.getSql(), selectedColumns);
        }

        public Builder mapCsvColumnToTableColumn(String expression, String column) {
            this.aliases.put(column, expression + " as " + column);
            return this;
        }

        public Builder tableColumns(List<String> tableColumns) {
            this.tableColumns = new ArrayList<String>(tableColumns);
            return this;
        }

        public Builder tableColumns(String ... tableColumns) {
            return this.tableColumns(Arrays.asList(tableColumns));
        }

        public String toString() {
            return "Builder [columns=" + this.tableColumns + ", aliases=" + this.aliases + ", csvRead=" + this.csvRead + "]";
        }

        public Builder valueType(Class<?> valueType) {
            Annotation[][] parameterAnnotationsOfConstructor = TableDefinition.getCanonicalConstructor(valueType).map(constructor -> constructor.getParameterAnnotations()).orElse(null);
            Field[] fields = (Field[])Stream.of(valueType.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers()) && !f.getName().startsWith("this$")).toArray(Field[]::new);
            ArrayList<Field> csvSkipColumns = new ArrayList<Field>();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                ArrayList<String> opt = new ArrayList<String>();
                opt.add(TableDefinition.toSqlDataType(field.getType()));
                LinkedHashSet anns = new LinkedHashSet();
                Arrays.stream(field.getAnnotations()).forEach(a -> anns.add(a));
                if (parameterAnnotationsOfConstructor != null) {
                    Arrays.stream(parameterAnnotationsOfConstructor[i]).forEach(a -> anns.add(a));
                }
                for (Annotation ann : anns) {
                    if (ann instanceof CsvColumn) {
                        this.mapCsvColumnToTableColumn(((CsvColumn)ann).value(), StringCache.toUpperSnakeCase(field.getName()));
                        continue;
                    }
                    if (!(ann instanceof SkipCsvRead)) continue;
                    csvSkipColumns.add(field);
                }
            }
            this.tableColumns((String[])Stream.of(fields).map(f -> csvSkipColumns.contains(f) ? "null as " + StringCache.toUpperSnakeCase(f.getName()) : StringCache.toUpperSnakeCase(f.getName())).toArray(String[]::new));
            return this;
        }

        public void csvRead(CsvRead csvRead) {
            this.csvRead = csvRead;
        }
    }
}

