/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.nkjmlab.sorm4j.util.h2.grammar.ScriptCompressionEncryption;
import org.nkjmlab.sorm4j.util.h2.internal.LiteralUtils;

public class RunScriptSql {
    private final String sql;

    public RunScriptSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> props = new LinkedHashMap<String, String>();
        private File fileName;
        private ScriptCompressionEncryption scriptCompressionEncryption = null;

        private void procProp(String key, BiConsumer<String, String> func) {
            String val = this.props.get(key);
            if (val == null) {
                return;
            }
            func.accept(key, val);
        }

        public Builder scriptCompressionEncryption(ScriptCompressionEncryption scriptCompressionEncryption) {
            this.scriptCompressionEncryption = scriptCompressionEncryption;
            return this;
        }

        public Builder charset(String val) {
            this.props.put("charset", val);
            return this;
        }

        public Builder from(File fileName) {
            this.fileName = fileName;
            return this;
        }

        public RunScriptSql build() {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("RUNSCRIPT FROM");
            ret.add(LiteralUtils.wrapSingleQuote(this.fileName.getAbsolutePath()));
            if (this.scriptCompressionEncryption != null) {
                ret.add(this.scriptCompressionEncryption.getSql());
            }
            this.procProp("charset", (key, val) -> ret.add(key + " " + val));
            return new RunScriptSql(String.join((CharSequence)" ", ret));
        }
    }
}

