/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.table;

import java.util.List;
import org.nkjmlab.sorm4j.Orm;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.common.TableMetaData;
import org.nkjmlab.sorm4j.common.Tuple;
import org.nkjmlab.sorm4j.mapping.ResultSetTraverser;
import org.nkjmlab.sorm4j.mapping.RowMapper;
import org.nkjmlab.sorm4j.result.InsertResult;
import org.nkjmlab.sorm4j.result.ResultSetStream;
import org.nkjmlab.sorm4j.result.RowMap;
import org.nkjmlab.sorm4j.sql.ParameterizedSql;
import org.nkjmlab.sorm4j.util.sql.JoinSql;
import org.nkjmlab.sorm4j.util.sql.SelectSql;
import org.nkjmlab.sorm4j.util.sql.SqlKeyword;

@Experimental
public interface TableMappedOrm<T> {
    public Orm getOrm();

    public String getTableName();

    public Class<T> getValueType();

    default public T readFirst(ParameterizedSql sql) {
        return this.getOrm().readFirst(this.getValueType(), sql);
    }

    default public T readFirst(String sql, Object ... parameters) {
        return this.getOrm().readFirst(this.getValueType(), sql, parameters);
    }

    default public List<T> readList(ParameterizedSql sql) {
        return this.getOrm().readList(this.getValueType(), sql);
    }

    default public List<T> readList(String sql, Object ... parameters) {
        return this.getOrm().readList(this.getValueType(), sql, parameters);
    }

    default public T readOne(ParameterizedSql sql) {
        return this.getOrm().readOne(this.getValueType(), sql);
    }

    default public T readOne(String sql, Object ... parameters) {
        return this.getOrm().readOne(this.getValueType(), sql, parameters);
    }

    default public RowMapper<T> getRowMapper() {
        return this.getOrm().getRowMapper(this.getValueType());
    }

    default public ResultSetTraverser<List<T>> getResultSetTraverser() {
        return this.getOrm().getResultSetTraverser(this.getValueType());
    }

    default public TableMetaData getTableMetaData() {
        return this.getOrm().getTableMetaData(this.getValueType());
    }

    default public boolean exists(T object) {
        return this.getOrm().exists(object);
    }

    default public boolean exists(Object ... primaryKeyValues) {
        return this.getOrm().existsByPrimaryKey(this.getValueType(), primaryKeyValues);
    }

    default public int[] delete(List<T> objects) {
        return this.getOrm().deleteIn(this.getTableName(), objects);
    }

    default public int delete(T object) {
        return this.getOrm().deleteIn(this.getTableName(), object);
    }

    default public int[] delete(T ... objects) {
        return this.getOrm().deleteIn(this.getTableName(), objects);
    }

    default public int deleteAll() {
        return this.getOrm().deleteAllIn(this.getTableName());
    }

    @Experimental
    default public int deleteByPrimaryKey(Object ... primaryKeyValues) {
        return this.getOrm().deleteByPrimaryKey(this.getValueType(), primaryKeyValues);
    }

    @Experimental
    default public int deleteByPrimaryKeyIn(String tableName, Object ... primaryKeyValues) {
        return this.getOrm().deleteByPrimaryKeyIn(tableName, primaryKeyValues);
    }

    default public int[] insert(List<T> objects) {
        return this.getOrm().insertInto(this.getTableName(), objects);
    }

    default public int insert(T object) {
        return this.getOrm().insertInto(this.getTableName(), object);
    }

    default public int[] insert(T ... objects) {
        return this.getOrm().insertInto(this.getTableName(), objects);
    }

    default public int insertMapIn(RowMap object) {
        return this.getOrm().insertMapInto(this.getTableName(), object);
    }

    default public int[] insertMapIn(RowMap ... objects) {
        return this.getOrm().insertMapInto(this.getTableName(), objects);
    }

    default public int[] insertMapIn(List<RowMap> objects) {
        return this.getOrm().insertMapInto(this.getTableName(), objects);
    }

    default public InsertResult insertAndGet(List<T> objects) {
        return this.getOrm().insertAndGetIn(this.getTableName(), objects);
    }

    default public InsertResult insertAndGet(T object) {
        return this.getOrm().insertAndGetIn(this.getTableName(), object);
    }

    default public InsertResult insertAndGet(T ... objects) {
        return this.getOrm().insertAndGetIn(this.getTableName(), objects);
    }

    default public int[] merge(List<T> objects) {
        return this.getOrm().mergeIn(this.getTableName(), objects);
    }

    default public int merge(T object) {
        return this.getOrm().mergeIn(this.getTableName(), object);
    }

    default public int[] merge(T ... objects) {
        return this.getOrm().mergeIn(this.getTableName(), objects);
    }

    default public int[] update(List<T> objects) {
        return this.getOrm().updateWith(this.getTableName(), objects);
    }

    default public int update(T object) {
        return this.getOrm().updateWith(this.getTableName(), object);
    }

    default public int[] update(T ... objects) {
        return this.getOrm().updateWith(this.getTableName(), objects);
    }

    default public int updateByPrimaryKey(RowMap object, Object ... primaryKeyValues) {
        return this.getOrm().updateByPrimaryKeyIn(this.getTableName(), object, primaryKeyValues);
    }

    default public <S> List<Tuple.Tuple2<T, S>> joinUsing(TableMappedOrm<S> other, String ... columns) {
        return this.getOrm().joinUsing(this.getValueType(), other.getValueType(), columns);
    }

    default public <S> List<Tuple.Tuple2<T, S>> joinOn(TableMappedOrm<S> other, String onCondition) {
        return this.getOrm().joinOn(this.getValueType(), other.getValueType(), onCondition);
    }

    default public <S> List<Tuple.Tuple2<T, S>> leftJoinOn(TableMappedOrm<S> other, String onCondition) {
        return this.getOrm().leftJoinOn(this.getValueType(), other.getValueType(), onCondition);
    }

    default public List<T> selectAll() {
        return this.getOrm().selectAll(this.getValueType());
    }

    default public T selectByPrimaryKey(Object ... primaryKeyValues) {
        return this.getOrm().selectByPrimaryKey(this.getValueType(), primaryKeyValues);
    }

    default public List<T> selectListAllEqual(Object ... tupplesOfNameAndValue) {
        return this.getOrm().readList(this.getValueType(), this.getAllEqualSql(tupplesOfNameAndValue));
    }

    default public T selectFirstAllEqual(Object ... tupplesOfNameAndValue) {
        return this.getOrm().readFirst(this.getValueType(), this.getAllEqualSql(tupplesOfNameAndValue));
    }

    default public T selectOneAllEqual(Object ... tupplesOfNameAndValue) {
        return this.getOrm().readOne(this.getValueType(), this.getAllEqualSql(tupplesOfNameAndValue));
    }

    default public ParameterizedSql getAllEqualSql(Object ... tupplesOfNameAndValue) {
        int argLength = tupplesOfNameAndValue.length;
        if (argLength == 0) {
            return ParameterizedSql.of(SelectSql.selectStarFrom(this.getTableName()));
        }
        int pairLength = argLength / 2;
        CharSequence[] conditions = new String[pairLength];
        Object[] parameters = new Object[pairLength];
        for (int i = 0; i < pairLength; ++i) {
            conditions[i] = tupplesOfNameAndValue[i * 2] + "=?";
            parameters[i] = tupplesOfNameAndValue[i * 2 + 1];
        }
        return ParameterizedSql.of(SelectSql.selectStarFrom(this.getTableName()) + SqlKeyword.WHERE + String.join((CharSequence)SqlKeyword.AND, conditions), parameters);
    }

    default public int count() {
        return this.getOrm().readOne(Integer.TYPE, "select count(*) from " + this.getTableName(), new Object[0]);
    }

    default public ResultSetStream<T> streamAll() {
        return this.getOrm().streamAll(this.getValueType());
    }

    default public ResultSetStream<T> stream(ParameterizedSql sql) {
        return this.stream(sql.getSql(), sql.getParameters());
    }

    default public ResultSetStream<T> stream(String sql, Object ... parameters) {
        return this.getOrm().stream(this.getValueType(), sql, parameters);
    }

    @Experimental
    default public <S> List<Tuple.Tuple2<T, S>> join(TableMappedOrm<S> second, String sql, Object ... parameters) {
        return this.getOrm().join(this.getValueType(), second.getValueType(), sql, parameters);
    }

    @Experimental
    default public <S, U> List<Tuple.Tuple3<T, S, U>> join(TableMappedOrm<S> second, TableMappedOrm<U> third, String sql, Object ... parameters) {
        return this.getOrm().join(this.getValueType(), second.getValueType(), third.getValueType(), sql, parameters);
    }

    @Experimental
    default public JoinSql.Builder joinSqlBuilder() {
        return JoinSql.builder(this);
    }
}

