/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.h2.server;

import java.io.File;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.internal.util.SystemPropertyUtils;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.util.h2.server.H2ServerProperties;

@Experimental
public abstract class H2ServerPropertiesBuilder<T extends H2ServerPropertiesBuilder<T>> {
    String javaCommand = Try.getOrElse(() -> SystemPropertyUtils.findJavaCommand(), "");
    String h2ClassPath = Try.getOrElse(() -> SystemPropertyUtils.findClassPathElement("^h2-[0-9\\.]*.jar$"), "");
    String serverType;
    int port;
    String password;
    String[] options = new String[0];

    public H2ServerPropertiesBuilder(String serverType, int port, String password) {
        this.setServerType(serverType);
        this.setPort(port);
        this.setPassword(password);
    }

    public H2ServerPropertiesBuilder<T> setJavaCommand(String javaCommand) {
        this.javaCommand = javaCommand;
        return this.getThisBuilder();
    }

    public H2ServerPropertiesBuilder<T> setH2ClassPath(String h2ClassPath) {
        this.h2ClassPath = h2ClassPath;
        return this.getThisBuilder();
    }

    public H2ServerPropertiesBuilder<T> setServerType(String serverType) {
        this.serverType = serverType;
        return this.getThisBuilder();
    }

    public H2ServerPropertiesBuilder<T> setPort(int port) {
        this.port = port;
        return this.getThisBuilder();
    }

    public T setPassword(String password) {
        this.password = password;
        return this.getThisBuilder();
    }

    public abstract T getThisBuilder();

    public H2ServerPropertiesBuilder<T> setOptions(String ... options) {
        this.options = options;
        return this;
    }

    public String getH2ClassPath() {
        return SystemPropertyUtils.convertTildeInFilePath(new File(this.h2ClassPath)).getAbsolutePath();
    }

    public abstract H2ServerProperties build();
}

