/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.context.logging;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.nkjmlab.sorm4j.context.logging.SormLogger;
import org.nkjmlab.sorm4j.internal.context.logging.LogContextImpl;
import org.nkjmlab.sorm4j.internal.context.logging.LogPoint;

public interface LogContext {
    public static Builder builder() {
        return new Builder();
    }

    public Optional<LogPoint> createLogPoint(Category var1, Class<?> var2);

    public SormLogger getLogger(Class<?> var1);

    public boolean isEnable(Category var1);

    public static class Builder {
        private Supplier<SormLogger> loggerSupplier;
        private final Set<Category> onCategories = new HashSet<Category>();

        Builder() {
        }

        public LogContext build() {
            return new LogContextImpl(this.loggerSupplier, this.onCategories);
        }

        public Builder disable(Category ... categories) {
            Arrays.stream(categories).forEach(name -> this.onCategories.remove(name));
            return this;
        }

        public Builder disableAll() {
            this.disable(Category.values());
            return this;
        }

        public Builder enable(Category ... categories) {
            Arrays.stream(categories).forEach(name -> this.onCategories.add((Category)((Object)name)));
            return this;
        }

        public Builder enableAll() {
            this.enable(Category.values());
            return this;
        }

        public Builder setLoggerSupplier(Supplier<SormLogger> loggerSupplier) {
            this.loggerSupplier = loggerSupplier;
            return this;
        }
    }

    public static enum Category {
        MAPPING_TO_TABLE,
        MAPPING_TO_COLUMNS,
        EXECUTE_QUERY,
        EXECUTE_UPDATE,
        EXECUTE_MULTI_ROW_UPDATE;

    }
}

