/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.datatype.jackson;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.nkjmlab.sorm4j.extension.datatype.SupportTypes;
import org.nkjmlab.sorm4j.extension.datatype.jackson.annotation.OrmJacksonColumn;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;

class JacksonSupportTypes
implements SupportTypes {
    private final Set<Class<?>> cache = ConcurrentHashMap.newKeySet();

    JacksonSupportTypes() {
    }

    @Override
    public boolean isSupport(Class<?> toType) {
        if (this.testType(toType)) {
            return true;
        }
        Class<?> componentType = ArrayUtils.getInternalComponentType(toType);
        if (componentType == null) {
            return false;
        }
        return this.testType(componentType);
    }

    private boolean testType(Class<?> toType) {
        if (toType == null) {
            return false;
        }
        if (this.cache.contains(toType)) {
            return true;
        }
        if (toType.getAnnotation(OrmJacksonColumn.class) != null) {
            this.cache.add(toType);
            return true;
        }
        if (List.class.isAssignableFrom(toType) || Map.class.isAssignableFrom(toType)) {
            this.cache.add(toType);
            return true;
        }
        return false;
    }
}

