/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.h2.functions.table;

import java.io.File;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.extension.h2.grammar.CsvOptions;
import org.nkjmlab.sorm4j.sql.statement.SqlStringUtils;

public class CsvRead {
    private final String sql;
    private final List<String> csvColumns;

    public CsvRead(String sql, List<String> csvColumns) {
        this.sql = sql;
        this.csvColumns = csvColumns;
    }

    public String getSql() {
        return this.sql;
    }

    public String toString() {
        return this.sql;
    }

    public static Builder builderForCsvWithHeader(File csvFile) {
        return new Builder().file(csvFile);
    }

    public static Builder builderForCsvWithoutHeader(File csvFile, List<String> csvColumns) {
        return new Builder().file(csvFile).columns(csvColumns);
    }

    public static Builder builderForCsvWithoutHeader(File csvFile, int csvColumnsCount) {
        return CsvRead.builderForCsvWithoutHeader(csvFile, IntStream.range(0, csvColumnsCount).mapToObj(i -> "COL_" + i).toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getCsvColumns() {
        return this.csvColumns;
    }

    public static class Builder {
        private File file;
        private List<String> columns;
        private final CsvOptions.Builder csvOptionsBuilder = new CsvOptions.Builder();

        public Builder columns(List<String> columns) {
            this.columns = columns;
            return this;
        }

        public Builder file(File file) {
            this.file = file;
            return this;
        }

        public Builder caseSensitiveColumnNames(boolean caseSensitiveColumnNames) {
            this.csvOptionsBuilder.caseSensitiveColumnNames(caseSensitiveColumnNames);
            return this;
        }

        public Builder charset(String val) {
            this.csvOptionsBuilder.charset(val);
            return this;
        }

        public Builder escape(String val) {
            this.csvOptionsBuilder.escape(val);
            return this;
        }

        public Builder fieldDelimiter(String val) {
            this.csvOptionsBuilder.fieldDelimiter(val);
            return this;
        }

        public Builder fieldSeparator(String val) {
            this.csvOptionsBuilder.fieldSeparator(val);
            return this;
        }

        public Builder lineComment(String val) {
            this.csvOptionsBuilder.lineComment(val);
            return this;
        }

        public Builder lineSeparator(String val) {
            this.csvOptionsBuilder.lineSeparator(val);
            return this;
        }

        public Builder nullString(String val) {
            this.csvOptionsBuilder.nullString(val);
            return this;
        }

        public Builder quotedNulls(boolean val) {
            this.csvOptionsBuilder.quotedNulls(val);
            return this;
        }

        public Builder preserveWhitespace(boolean val) {
            this.csvOptionsBuilder.preserveWhitespace(val);
            return this;
        }

        public Builder writeColumnHeader(boolean val) {
            this.csvOptionsBuilder.writeColumnHeader(val);
            return this;
        }

        public CsvRead build() {
            CsvOptions csvOptions = this.csvOptionsBuilder.build();
            String columnsString = this.columns == null ? null : String.join((CharSequence)csvOptions.getFieldSeparator(), this.columns);
            List<String> l = Stream.of(SqlStringUtils.quote(this.file.getAbsolutePath().toString()), columnsString == null ? null : SqlStringUtils.quote(columnsString), csvOptions == null || csvOptions.getSql() == null ? null : "stringdecode(" + SqlStringUtils.quote(csvOptions.getSql()) + ")").toList();
            return new CsvRead("csvread(" + String.join((CharSequence)", ", l) + ")", this.columns);
        }
    }
}

