/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.h2.grammar;

import java.util.Map;
import java.util.TreeMap;
import org.nkjmlab.sorm4j.sql.statement.SqlStringUtils;

public class CsvOptions {
    private final String sql;
    private final String fieldSeparator;

    public CsvOptions(String sql, String fieldSeparator) {
        this.sql = sql;
        this.fieldSeparator = fieldSeparator;
    }

    public String getSql() {
        return this.sql;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> csvOptions = new TreeMap<String, String>();

        public Builder caseSensitiveColumnNames(boolean caseSensitiveColumnNames) {
            return this.putCsvOption("caseSensitiveColumnNames", "" + caseSensitiveColumnNames);
        }

        public Builder charset(String val) {
            return this.putCsvOption("charset", val);
        }

        public Builder escape(String val) {
            return this.putCsvOption("escape", val);
        }

        public Builder fieldDelimiter(String val) {
            return this.putCsvOption("fieldDelimiter", val);
        }

        public Builder fieldSeparator(String val) {
            return this.putCsvOption("fieldSeparator", val);
        }

        public Builder lineComment(String val) {
            return this.putCsvOption("lineComment", val);
        }

        public Builder lineSeparator(String val) {
            return this.putCsvOption("lineSeparator", val);
        }

        public Builder nullString(String val) {
            return this.putCsvOption("null", val);
        }

        public Builder quotedNulls(boolean val) {
            return this.putCsvOption("quotedNulls", "" + val);
        }

        public Builder preserveWhitespace(boolean val) {
            return this.putCsvOption("preserveWhitespace", "" + val);
        }

        public Builder writeColumnHeader(boolean val) {
            return this.putCsvOption("writeColumnHeader", "" + val);
        }

        private Builder putCsvOption(String key, String val) {
            this.csvOptions.put(key, val);
            return this;
        }

        public CsvOptions build() {
            String optionsString = this.csvOptions.size() == 0 ? null : String.join((CharSequence)" ", this.csvOptions.entrySet().stream().map(en -> (String)en.getKey() + "=" + SqlStringUtils.escapeJavaString((String)en.getValue())).toList());
            return new CsvOptions(optionsString, this.csvOptions.getOrDefault("fieldSeparator", ","));
        }
    }
}

