/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.h2.tools.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.sql.SQLException;
import org.h2.server.Service;
import org.h2.tools.Server;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public interface H2Server {
    public Server getServer();

    public void stop() throws SQLException;

    default public boolean isPortFree() {
        boolean bl;
        ServerSocket socket = new ServerSocket(this.getPort());
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    default public boolean isRunning() {
        return this.getServer().isRunning(false);
    }

    default public Service getService() {
        return this.getServer().getService();
    }

    default public String getStatus() {
        return this.getServer().getStatus();
    }

    default public int getPort() {
        return this.getServer().getPort();
    }

    default public String getUrl() {
        return this.getServer().getURL();
    }

    default public void start() {
        if (this.isRunning()) {
            return;
        }
        try {
            this.getServer().start();
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }
}

