/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.context.MultiRowProcessorFactory;
import org.nkjmlab.sorm4j.context.SormContext;
import org.nkjmlab.sorm4j.context.TableNameMapper;
import org.nkjmlab.sorm4j.context.logging.LogContext;
import org.nkjmlab.sorm4j.internal.SormConfig;
import org.nkjmlab.sorm4j.internal.context.ColumnToFieldAccessorMapper;
import org.nkjmlab.sorm4j.internal.context.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.internal.context.ColumnValueToMapValueConverters;
import org.nkjmlab.sorm4j.internal.context.PreparedStatementSupplier;
import org.nkjmlab.sorm4j.internal.context.SqlParametersSetter;
import org.nkjmlab.sorm4j.internal.context.TableSqlFactory;
import org.nkjmlab.sorm4j.internal.context.common.TableMetaDataImpl;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMapping;
import org.nkjmlab.sorm4j.internal.mapping.ContainerToTableMapper;
import org.nkjmlab.sorm4j.internal.mapping.result.ResultsToContainerMapper;
import org.nkjmlab.sorm4j.internal.sql.TableName;
import org.nkjmlab.sorm4j.internal.sql.metadata.ColumnMetaData;
import org.nkjmlab.sorm4j.internal.sql.metadata.DbMetaData;
import org.nkjmlab.sorm4j.internal.sql.metadata.TableMetaData;
import org.nkjmlab.sorm4j.sql.TableSql;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public final class SormContextImpl
implements SormContext {
    private final ConcurrentMap<String, TableMetaData> tableMetaDataMap;
    private final ConcurrentMap<String, TableSql> tableSqlMap;
    private final ConcurrentMap<Class<?>, TableName> classNameToValidTableNameMap;
    private final ConcurrentMap<String, TableName> tableNameToValidTableNameMap;
    private final ConcurrentMap<Class<?>, Map<String, ContainerToTableMapper<?>>> sqlParametersToTableMappings;
    private final ConcurrentMap<Class<?>, ResultsToContainerMapper<?>> sqlResultToColumnsMappings;
    private final SormConfig config;

    SormContextImpl(SormConfig sormConfig) {
        this.config = sormConfig;
        this.tableMetaDataMap = new ConcurrentHashMap<String, TableMetaData>();
        this.tableSqlMap = new ConcurrentHashMap<String, TableSql>();
        this.classNameToValidTableNameMap = new ConcurrentHashMap();
        this.tableNameToValidTableNameMap = new ConcurrentHashMap<String, TableName>();
        this.sqlParametersToTableMappings = new ConcurrentHashMap();
        this.sqlResultToColumnsMappings = new ConcurrentHashMap();
    }

    public SormContextImpl(LogContext loggerContext, ColumnToFieldAccessorMapper columnFieldMapper, TableNameMapper tableNameMapper, ColumnValueToJavaObjectConverters columnValueToJavaObjectConverter, ColumnValueToMapValueConverters columnValueToMapValueConverter, SqlParametersSetter sqlParametersSetter, PreparedStatementSupplier statementSupplier, TableSqlFactory tableSqlFactory, MultiRowProcessorFactory multiRowProcessorFactory) {
        this(new SormConfig(loggerContext, columnFieldMapper, tableNameMapper, columnValueToJavaObjectConverter, columnValueToMapValueConverter, sqlParametersSetter, statementSupplier, tableSqlFactory, multiRowProcessorFactory));
    }

    TableMetaData getTableMetaData(Connection connection, String tableName) {
        return this.getTableMetaData(connection, tableName, NoValueType.class);
    }

    <T> TableMetaData getTableMetaData(Connection connection, String tableName, Class<T> objectClass) {
        TableName _tableName = this.toTableName(connection, tableName);
        TableMetaData ret = this.tableMetaDataMap.computeIfAbsent(_tableName.getName(), _key -> {
            try {
                return this.createTableMetaData(objectClass, _tableName.getName(), connection.getMetaData());
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
        return ret;
    }

    public <T> TableSql getTableSql(Connection connection, TableMetaData tableMetaData) {
        return this.tableSqlMap.computeIfAbsent(tableMetaData.getTableName(), _key -> {
            try {
                return this.config.getTableSqlFactory().create(tableMetaData, DbMetaData.of(connection.getMetaData()));
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
    }

    <T> ContainerToTableMapper<T> getTableMapping(Connection connection, Class<T> objectClass) {
        return this.getTableMapping(connection, this.toTableName(connection, objectClass), objectClass);
    }

    <T> ContainerToTableMapper<T> getTableMapping(Connection connection, String tableName, Class<T> objectClass) {
        return this.getTableMapping(connection, this.toTableName(connection, tableName), objectClass);
    }

    <T> ContainerToTableMapper<T> getTableMapping(Connection connection, TableName tableName, Class<T> objectClass) {
        ContainerToTableMapper ret = this.sqlParametersToTableMappings.computeIfAbsent(objectClass, _k -> new ConcurrentHashMap()).computeIfAbsent(tableName.getName(), _k -> {
            try {
                ContainerToTableMapper m = this.createTableMapping(objectClass, tableName.getName(), connection);
                this.config.getLoggerContext().createLogPoint(LogContext.Category.MAPPING_TO_TABLE, SormContext.class).ifPresent(lp -> lp.logMapping(m.toString()));
                return m;
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
        return ret;
    }

    <T> ResultsToContainerMapper<T> createColumnsMapping(Class<T> objectClass) {
        ColumnToAccessorMapping columnToAccessorMap = new ColumnToAccessorMapping(objectClass, this.config.getColumnToFieldAccessorMapper().createMapping(objectClass), this.config.getColumnToFieldAccessorMapper().getColumnAliasPrefix(objectClass));
        return new ResultsToContainerMapper<T>(this.config.getColumnValueToJavaObjectConverter(), objectClass, columnToAccessorMap);
    }

    <T> ContainerToTableMapper<T> createTableMapping(Class<T> objectClass, String tableName, Connection connection) throws SQLException {
        ColumnToAccessorMapping columnToAccessorMap = new ColumnToAccessorMapping(objectClass, this.config.getColumnToFieldAccessorMapper().createMapping(objectClass), this.config.getColumnToFieldAccessorMapper().getColumnAliasPrefix(objectClass));
        TableMetaData tableMetaData = this.getTableMetaData(connection, tableName, objectClass);
        TableSql sql = this.getTableSql(connection, tableMetaData);
        return new ContainerToTableMapper<T>(this.config.getLoggerContext(), this.config.getColumnValueToJavaObjectConverter(), this.config.getSqlParametersSetter(), this.config.getPreparedStatementSupplier(), this.config.getMultiRowProcessorFactory(), objectClass, columnToAccessorMap, tableMetaData, sql);
    }

    private <T> TableMetaDataImpl createTableMetaData(Class<T> objectClass, String tableName, DatabaseMetaData metaData) throws SQLException {
        List<ColumnMetaData> columns = this.config.getTableMetaDataReader().getColumnsMetaData(metaData, tableName);
        List<String> primaryKeys = this.config.getTableMetaDataReader().getPrimaryKeys(metaData, tableName);
        List<String> autoGeneratedColumns = this.config.getTableMetaDataReader().getAutoGeneratedColumns(metaData, tableName);
        String prefix = this.config.getColumnToFieldAccessorMapper().getColumnAliasPrefix(objectClass);
        return new TableMetaDataImpl(tableName, prefix, columns, primaryKeys, autoGeneratedColumns);
    }

    <T> ContainerToTableMapper<T> getCastedTableMapping(Connection connection, Class<?> objectClass) {
        return this.getTableMapping(connection, objectClass);
    }

    <T> ContainerToTableMapper<T> getCastedTableMapping(Connection connection, String tableName, Class<?> objectClass) {
        return this.getTableMapping(connection, tableName, objectClass);
    }

    <T> ResultsToContainerMapper<T> getColumnsMapping(Class<T> objectClass) {
        ResultsToContainerMapper ret = this.sqlResultToColumnsMappings.computeIfAbsent(objectClass, _k -> {
            ResultsToContainerMapper m = this.createColumnsMapping(objectClass);
            this.config.getLoggerContext().createLogPoint(LogContext.Category.MAPPING_TO_COLUMNS, SormContext.class).ifPresent(lp -> lp.logMapping(m.toString()));
            return m;
        });
        return ret;
    }

    private TableName toTableName(Connection connection, Class<?> objectClass) {
        return this.classNameToValidTableNameMap.computeIfAbsent(objectClass, k -> {
            try {
                return TableName.of(this.config.getTableNameMapper().getTableName(objectClass, connection.getMetaData()));
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
    }

    String getTableName(Connection connection, Class<?> objectClass) {
        return this.toTableName(connection, objectClass).getName();
    }

    private TableName toTableName(Connection connection, String tableName) {
        return this.tableNameToValidTableNameMap.computeIfAbsent(tableName, k -> {
            try {
                return TableName.of(this.config.getTableNameMapper().getTableName(tableName, connection.getMetaData()));
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        });
    }

    @Override
    public LogContext getLogContext() {
        return this.config.getLoggerContext();
    }

    @Override
    public ColumnValueToJavaObjectConverters getColumnValueToJavaObjectConverter() {
        return this.config.getColumnValueToJavaObjectConverter();
    }

    @Override
    public ColumnValueToMapValueConverters getColumnValueToMapValueConverter() {
        return this.config.getColumnValueToMapValueConverter();
    }

    @Override
    public SqlParametersSetter getSqlParametersSetter() {
        return this.config.getSqlParametersSetter();
    }

    @Override
    public PreparedStatementSupplier getPreparedStatementSupplier() {
        return this.config.getPreparedStatementSupplier();
    }

    public String toString() {
        return "SormContext {" + System.lineSeparator() + "[Table metadata]" + System.lineSeparator() + this.convertMapToString(this.tableMetaDataMap) + System.lineSeparator() + "[SqlParameterToTableMappings]" + System.lineSeparator() + this.convertNestedMapToString(this.sqlParametersToTableMappings) + System.lineSeparator() + "[SqlResultToColumnsMapping]" + System.lineSeparator() + this.convertClassMapToString(this.sqlResultToColumnsMappings) + System.lineSeparator() + "[classNameToValidTableNameMap]" + System.lineSeparator() + this.convertClassMapToString(this.classNameToValidTableNameMap) + System.lineSeparator() + "[tableNameToValidTableNameMap]" + System.lineSeparator() + this.convertMapToString(this.tableNameToValidTableNameMap) + System.lineSeparator() + "[SormConfig]" + System.lineSeparator() + String.valueOf(this.config) + System.lineSeparator() + "}";
    }

    private String convertClassMapToString(Map<Class<?>, ? extends Object> map) {
        return this.convertMapToString(map.entrySet().stream().collect(Collectors.toMap(e -> ((Class)e.getKey()).getName(), e -> e.getValue())));
    }

    private String convertMapToString(Map<String, ? extends Object> map) {
        List keySet = map.keySet().stream().sorted().collect(Collectors.toList());
        return String.join((CharSequence)System.lineSeparator(), keySet.stream().map(e -> e + " => " + map.get(e).toString()).collect(Collectors.toList()));
    }

    private String convertNestedMapToString(Map<Class<?>, Map<String, ContainerToTableMapper<?>>> sqlParametersToTableMappings) {
        return sqlParametersToTableMappings.entrySet().stream().map(entry -> {
            Class outerKey = (Class)entry.getKey();
            Map innerMap = (Map)entry.getValue();
            String innerMapStr = innerMap.entrySet().stream().map(innerEntry -> "  " + (String)innerEntry.getKey() + " => " + String.valueOf(innerEntry.getValue())).collect(Collectors.joining(System.lineSeparator()));
            return String.valueOf(outerKey) + ":" + System.lineSeparator() + innerMapStr;
        }).collect(Collectors.joining(System.lineSeparator() + System.lineSeparator()));
    }

    @Override
    public SormContext.Builder builder() {
        return SormContext.builder().setLogContext(this.config.getLoggerContext()).setMultiRowProcessorFactory(this.config.getMultiRowProcessorFactory()).setTableNameMapper(this.config.getTableNameMapper()).setTableSqlFactory(this.config.getTableSqlFactory());
    }

    private static class NoValueType {
        private NoValueType() {
        }
    }
}

