/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.context.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.context.SormContext;
import org.nkjmlab.sorm4j.internal.sql.metadata.ColumnMetaData;
import org.nkjmlab.sorm4j.internal.sql.metadata.TableMetaData;

public final class TableMetaDataImpl
implements TableMetaData {
    private final String tableName;
    private final List<String> columns;
    private final List<String> primaryKeys;
    private final List<String> autoGeneratedColumns;
    private final boolean hasPrimaryKey;
    private final boolean hasAutoGeneratedColumns;
    private final List<String> notAutoGeneratedColumns;
    private final List<String> columnsForUpdate;
    private final String[] autoGeneratedColumnsArray;
    private final List<String> notPrimaryKeys;
    private final List<String> columnsWithAliases;
    private final List<ColumnMetaData> columnsWithMetaData;

    public TableMetaDataImpl(String tableName, String columnAliasPrefix, List<ColumnMetaData> columnsWithMetaData, List<String> primaryKeys, List<String> autoGeneratedColumns) {
        this.tableName = tableName;
        this.columnsWithMetaData = List.copyOf(columnsWithMetaData);
        this.columns = Collections.unmodifiableList(columnsWithMetaData.stream().map(c -> c.getColumnName()).collect(Collectors.toList()));
        this.primaryKeys = Collections.unmodifiableList(primaryKeys);
        this.autoGeneratedColumns = Collections.unmodifiableList(autoGeneratedColumns);
        this.notAutoGeneratedColumns = Collections.unmodifiableList(this.columns.stream().filter(col -> !autoGeneratedColumns.contains(col)).collect(Collectors.toList()));
        this.hasPrimaryKey = !primaryKeys.isEmpty();
        this.hasAutoGeneratedColumns = !autoGeneratedColumns.isEmpty();
        this.autoGeneratedColumnsArray = (String[])autoGeneratedColumns.toArray(String[]::new);
        this.notPrimaryKeys = Collections.unmodifiableList(this.columns.stream().filter(col -> !primaryKeys.contains(col)).collect(Collectors.toList()));
        this.columnsForUpdate = Collections.unmodifiableList(Stream.concat(this.notPrimaryKeys.stream(), primaryKeys.stream()).collect(Collectors.toList()));
        this.columnsWithAliases = this.columns.stream().map(col -> tableName + "." + col + " as " + SormContext.getDefaultCanonicalStringCache().toCanonicalNameWithTableName(columnAliasPrefix, (String)col)).collect(Collectors.toList());
    }

    @Override
    public List<String> getAutoGeneratedColumns() {
        return this.autoGeneratedColumns;
    }

    @Override
    public String[] getAutoGeneratedColumnsArray() {
        return this.autoGeneratedColumnsArray;
    }

    @Override
    public List<String> getColumnAliases() {
        return this.columnsWithAliases;
    }

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public List<String> getColumnsForUpdate() {
        return this.columnsForUpdate;
    }

    @Override
    public List<ColumnMetaData> getColumnsMetaData() {
        return this.columnsWithMetaData;
    }

    @Override
    public List<String> getNotAutoGeneratedColumns() {
        return this.notAutoGeneratedColumns;
    }

    @Override
    public List<String> getNotPrimaryKeys() {
        return this.notPrimaryKeys;
    }

    @Override
    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public boolean hasAutoGeneratedColumns() {
        return this.hasAutoGeneratedColumns;
    }

    @Override
    public boolean hasPrimaryKey() {
        return this.hasPrimaryKey;
    }

    public String toString() {
        return "TableMetaDataImpl [tableName=" + this.tableName + ", columns=" + String.valueOf(this.columns) + ", primaryKeys=" + String.valueOf(this.primaryKeys) + ", autoGeneratedColumns=" + String.valueOf(this.autoGeneratedColumns) + ", hasPrimaryKey=" + this.hasPrimaryKey + ", hasAutoGeneratedColumns=" + this.hasAutoGeneratedColumns + ", notAutoGeneratedColumns=" + String.valueOf(this.notAutoGeneratedColumns) + ", columnsForUpdate=" + String.valueOf(this.columnsForUpdate) + ", autoGeneratedColumnsArray=" + Arrays.toString(this.autoGeneratedColumnsArray) + ", notPrimaryKeys=" + String.valueOf(this.notPrimaryKeys) + ", columnsWithAliases=" + String.valueOf(this.columnsWithAliases) + ", columnsWithMetaData=" + String.valueOf(this.columnsWithMetaData) + "]";
    }
}

