/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.context.impl;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.nkjmlab.sorm4j.common.exception.SormException;
import org.nkjmlab.sorm4j.context.ColumnValueToJavaObjectConverter;
import org.nkjmlab.sorm4j.extension.datatype.container.GeometryText;
import org.nkjmlab.sorm4j.extension.datatype.container.JsonByte;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;
import org.nkjmlab.sorm4j.internal.util.JdbcTypeUtils;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public final class DefaultColumnValueToJavaObjectConverter
implements ColumnValueToJavaObjectConverter {
    private final Set<Class<?>> supportedComponentTypes = Set.of(Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, InputStream.class, Reader.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, String.class, Object.class, BigDecimal.class, Clob.class, Blob.class, Date.class, Time.class, Timestamp.class, Instant.class, LocalDate.class, LocalTime.class, LocalDateTime.class, OffsetTime.class, OffsetDateTime.class, java.util.Date.class, UUID.class, JsonByte.class, GeometryText.class);

    @Override
    public boolean test(Class<?> objectClass) {
        return this.supportedComponentTypes.contains(objectClass) || objectClass.isArray() && this.supportedComponentTypes.contains(ArrayUtils.getInternalComponentType(objectClass.getComponentType()));
    }

    @Override
    public <T> T convertTo(ResultSet resultSet, int columnIndex, int columnType, Class<T> toType) throws SQLException {
        Object value = this.convertToAux(resultSet, columnIndex, columnType, toType);
        if (toType.isPrimitive()) {
            Object val = value;
            return (T)val;
        }
        return toType.cast(value);
    }

    private Object convertToAux(ResultSet resultSet, int columnIndex, int columnType, Class<?> toType) throws SQLException {
        if (toType.isEnum()) {
            return this.procEnum(resultSet, columnIndex, columnType, toType);
        }
        if (toType.isArray()) {
            return this.procArray(resultSet, columnIndex, columnType, toType);
        }
        return this.procCommonTypeValue(resultSet, columnIndex, columnType, toType);
    }

    private Object procCommonTypeValue(ResultSet resultSet, int columnIndex, int columnType, Class<?> toType) throws SQLException {
        String typeName;
        switch (typeName = toType.getName()) {
            case "boolean": {
                return resultSet.getBoolean(columnIndex);
            }
            case "byte": {
                return resultSet.getByte(columnIndex);
            }
            case "short": {
                return resultSet.getShort(columnIndex);
            }
            case "int": {
                return resultSet.getInt(columnIndex);
            }
            case "long": {
                return resultSet.getLong(columnIndex);
            }
            case "float": {
                return Float.valueOf(resultSet.getFloat(columnIndex));
            }
            case "double": {
                return resultSet.getDouble(columnIndex);
            }
            case "java.lang.String": {
                return resultSet.getString(columnIndex);
            }
            case "char": {
                return Character.valueOf(resultSet.getString(columnIndex) != null && !resultSet.getString(columnIndex).isEmpty() ? resultSet.getString(columnIndex).charAt(0) : (char)'\u0000');
            }
            case "java.lang.Character": {
                return Optional.ofNullable(resultSet.getString(columnIndex)).filter(str -> !str.isEmpty()).map(str -> Character.valueOf(str.charAt(0))).orElse(null);
            }
            case "java.lang.Object": {
                return resultSet.getObject(columnIndex);
            }
            case "java.io.InputStream": {
                return resultSet.getBinaryStream(columnIndex);
            }
            case "java.io.Reader": {
                return resultSet.getCharacterStream(columnIndex);
            }
            case "java.math.BigDecimal": {
                return resultSet.getBigDecimal(columnIndex);
            }
            case "java.sql.Date": {
                return resultSet.getDate(columnIndex);
            }
            case "java.sql.Time": {
                return resultSet.getTime(columnIndex);
            }
            case "java.sql.Timestamp": {
                return resultSet.getTimestamp(columnIndex);
            }
            case "java.sql.Blob": {
                return resultSet.getBlob(columnIndex);
            }
            case "java.sql.Clob": {
                return resultSet.getClob(columnIndex);
            }
            case "org.nkjmlab.sorm4j.extension.datatype.container.JsonByte": {
                return JsonByte.of(resultSet.getBytes(columnIndex));
            }
            case "org.nkjmlab.sorm4j.extension.datatype.container.GeometryText": {
                return GeometryText.of(resultSet.getString(columnIndex));
            }
        }
        return resultSet.getObject(columnIndex, toType);
    }

    private Enum procEnum(ResultSet resultSet, int columnIndex, int columnType, Class<?> toType) throws SQLException {
        String str = resultSet.getString(columnIndex);
        try {
            return Enum.valueOf(toType, str);
        }
        catch (Exception e) {
            String tableName = Try.getOrElse(() -> resultSet.getMetaData().getTableName(columnIndex), "UNKNOWN_TABLE");
            String columnLabel = Try.getOrElse(() -> resultSet.getMetaData().getColumnLabel(columnIndex), "UNKNOWN_COLUMN");
            Object[] params = new Object[]{str, JDBCType.valueOf(columnType), toType, tableName, columnLabel};
            throw new SormException(ParameterizedStringFormatter.LENGTH_256.format("Could not convert [{}] in column [{}] to  Enum [{}], tableName=[{}], columnLabel=[{}]", params), e);
        }
    }

    private Object procArray(ResultSet resultSet, int columnIndex, int columnType, Class<?> toType) throws SQLException {
        if (toType.getComponentType().equals(Byte.TYPE)) {
            return resultSet.getBytes(columnIndex);
        }
        try {
            return ArrayUtils.convertSqlArrayToArray(toType.getComponentType(), resultSet.getArray(columnIndex));
        }
        catch (Exception e) {
            String tableName = Try.getOrElse(() -> resultSet.getMetaData().getTableName(columnIndex), "UNKNOWN_TABLE");
            String columnLabel = Try.getOrElse(() -> resultSet.getMetaData().getColumnLabel(columnIndex), "UNKNOWN_COLUMN");
            Object[] params = new Object[]{JdbcTypeUtils.convert(columnType), toType, tableName, columnLabel};
            throw new SormException(ParameterizedStringFormatter.LENGTH_256.format("Could not convert column [{}] to  array [{}], tableName=[{}], columnLabel=[{}]", params), e);
        }
    }
}

