/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.context.impl;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.nkjmlab.sorm4j.common.exception.SormException;
import org.nkjmlab.sorm4j.context.ColumnValueToJavaObjectConverter;
import org.nkjmlab.sorm4j.internal.context.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.internal.context.impl.DefaultColumnValueToJavaObjectConverter;
import org.nkjmlab.sorm4j.internal.util.JdbcTypeUtils;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public final class DefaultColumnValueToJavaObjectConverters
implements ColumnValueToJavaObjectConverters {
    private final Map<Class<?>, Optional<ColumnValueToJavaObjectConverter>> converterHitCache;
    private final List<ColumnValueToJavaObjectConverter> converters;
    private final Map<Class<?>, Boolean> supportedValueTypeCache = new ConcurrentHashMap();
    private final ColumnValueToJavaObjectConverter defaultConverter = new DefaultColumnValueToJavaObjectConverter();

    @Override
    public boolean isSupportedComponentType(Class<?> objectClass) {
        return this.supportedValueTypeCache.computeIfAbsent(objectClass, key -> this.getHitConverter(objectClass).isPresent() || this.defaultConverter.test(objectClass));
    }

    public DefaultColumnValueToJavaObjectConverters(ColumnValueToJavaObjectConverter ... converters) {
        this.converters = Arrays.asList(converters);
        this.converterHitCache = this.converters.isEmpty() ? Collections.emptyMap() : new ConcurrentHashMap();
    }

    @Override
    public <T> T convertTo(ResultSet resultSet, int columnIndex, int columnType, Class<T> toType) {
        try {
            Optional<ColumnValueToJavaObjectConverter> _converter = this.getHitConverter(toType);
            return _converter.isPresent() ? _converter.get().convertTo(resultSet, columnIndex, columnType, toType) : this.defaultConverter.convertTo(resultSet, columnIndex, columnType, toType);
        }
        catch (Exception e) {
            String tableName = Try.getOrElse(() -> resultSet.getMetaData().getTableName(columnIndex), "UNKNOWN_TABLE");
            String columnLabel = Try.getOrElse(() -> resultSet.getMetaData().getColumnLabel(columnIndex), "UNKNOWN_COLUMN");
            Object[] params = new Object[]{tableName, columnLabel, columnIndex, JdbcTypeUtils.convert(columnType), toType};
            throw new SormException(ParameterizedStringFormatter.LENGTH_256.format("tableName=[{}], columnLabel=[{}], columnIndex=[{}], columnType=[{}], toType=[{}]", params), e);
        }
    }

    private Optional<ColumnValueToJavaObjectConverter> getHitConverter(Class<?> toType) {
        return this.converters.isEmpty() ? Optional.empty() : this.converterHitCache.computeIfAbsent(toType, key -> this.converters.stream().filter(conv -> conv.test(toType)).findAny());
    }
}

