/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.context.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.nkjmlab.sorm4j.common.exception.SormException;
import org.nkjmlab.sorm4j.context.SormContext;
import org.nkjmlab.sorm4j.context.TableNameMapper;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;
import org.nkjmlab.sorm4j.internal.util.reflection.RefrectionTableNameUtils;
import org.nkjmlab.sorm4j.mapping.annotation.OrmTableName;

public final class DefaultTableNameMapper
implements TableNameMapper {
    private static final String ERROR_MESSAGE = "[{}] does not match any existing table in the database. Use @{} annotation or rename the class. Table name candidates were {}";

    @Override
    public String getTableName(String tableName, DatabaseMetaData metaData) {
        List<String> candidates = List.of(tableName);
        Object[] params = new Object[]{tableName, OrmTableName.class.getSimpleName(), candidates};
        return this.convertToExactTableName(metaData, candidates).orElseThrow(() -> new SormException(ParameterizedStringFormatter.LENGTH_256.format(ERROR_MESSAGE, params)));
    }

    @Override
    public String getTableName(Class<?> objectClass, DatabaseMetaData metaData) {
        List<String> candidates = this.guessTableNameCandidates(objectClass);
        Object[] params = new Object[]{objectClass.getName(), OrmTableName.class.getSimpleName(), candidates};
        return this.convertToExactTableName(metaData, candidates).orElseThrow(() -> new SormException(ParameterizedStringFormatter.LENGTH_256.format(ERROR_MESSAGE, params)));
    }

    private List<String> guessTableNameCandidates(Class<?> objectClass) {
        Optional<String> annotatedTableName = RefrectionTableNameUtils.getAnotatedTableName(objectClass);
        if (annotatedTableName.isPresent()) {
            return List.of(annotatedTableName.get());
        }
        String className = objectClass.getSimpleName();
        String cannonicalClassName = SormContext.getDefaultCanonicalStringCache().toCanonicalName(className);
        ArrayList<String> candidates = new ArrayList<String>(List.of(cannonicalClassName, SormContext.getDefaultCanonicalStringCache().toCanonicalName(cannonicalClassName + "S"), SormContext.getDefaultCanonicalStringCache().toCanonicalName(cannonicalClassName + "ES")));
        if (cannonicalClassName.endsWith("Y")) {
            candidates.add(SormContext.getDefaultCanonicalStringCache().toCanonicalName(cannonicalClassName.substring(0, cannonicalClassName.length() - 1) + "IES"));
        }
        return candidates;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> convertToExactTableName(DatabaseMetaData metaData, List<String> tableNameCandidates) {
        try (ResultSet resultSet = metaData.getTables(null, null, "%", new String[]{"TABLE", "VIEW"});){
            while (resultSet.next()) {
                String tableNameOnDb = resultSet.getString(3);
                if (!SormContext.getDefaultCanonicalStringCache().containsCanonicalName(tableNameCandidates, tableNameOnDb)) continue;
                Optional<String> optional = Optional.of(tableNameOnDb);
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

