/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.context.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.common.container.RowMap;
import org.nkjmlab.sorm4j.internal.context.impl.DefaultTableSqlFactory;
import org.nkjmlab.sorm4j.internal.util.ConcurrentCache;
import org.nkjmlab.sorm4j.sql.TableSql;

public final class DefaultTableSql
implements TableSql {
    private final Map<String, String> multiRowSqlMap = new ConcurrentCache<String, String>(256);
    private final String insertPlaceholders;
    private final String mergePlaceholders;
    private final String selectByPrimaryKeySql;
    private final String selectAllSql;
    private final String insertSql;
    private final String updateSql;
    private final String deleteSql;
    private final String mergeSql;
    private final String existsSql;
    private final String insertSqlPrefix;
    private final String mergeSqlPrefix;
    private final DefaultTableSqlFactory.UpdateSqlFactory updateSqlFactory;

    public DefaultTableSql(String inserPlaceholders, String mergePlaceholders, String selectByPrimaryKeySql, String selectAllSql, String insertSql, String updateSql, String deleteSql, String mergeSql, String existsSql, String insertSqlPrefix, String mergeSqlPrefix, DefaultTableSqlFactory.UpdateSqlFactory updateSqlFactory, List<String> primaryKeys) {
        this.insertPlaceholders = inserPlaceholders;
        this.mergePlaceholders = mergePlaceholders;
        this.selectByPrimaryKeySql = selectByPrimaryKeySql;
        this.selectAllSql = selectAllSql;
        this.insertSql = insertSql;
        this.updateSql = updateSql;
        this.deleteSql = deleteSql;
        this.mergeSql = mergeSql;
        this.existsSql = existsSql;
        this.insertSqlPrefix = insertSqlPrefix;
        this.mergeSqlPrefix = mergeSqlPrefix;
        this.updateSqlFactory = updateSqlFactory;
    }

    @Override
    public String getDeleteSql() {
        return this.deleteSql;
    }

    @Override
    public String getInsertSql() {
        return this.insertSql;
    }

    @Override
    public String getMergeSql() {
        return this.mergeSql;
    }

    @Override
    public String getMultirowInsertSql(int num) {
        return this.getSqlWithMultirowPlaceholders(this.insertSqlPrefix, this.insertPlaceholders, num);
    }

    @Override
    public String getMultirowMergeSql(int num) {
        return this.getSqlWithMultirowPlaceholders(this.mergeSqlPrefix, this.mergePlaceholders, num);
    }

    private String getSqlWithMultirowPlaceholders(String sqlPrefix, String placeHolders, int repeat) {
        return this.multiRowSqlMap.computeIfAbsent(sqlPrefix + repeat, n -> sqlPrefix + String.join((CharSequence)",", Stream.generate(() -> placeHolders).limit(repeat).collect(Collectors.toList())));
    }

    @Override
    public String getSelectAllSql() {
        return this.selectAllSql;
    }

    @Override
    public String getSelectByPrimaryKeySql() {
        return this.selectByPrimaryKeySql;
    }

    @Override
    public String getUpdateSql() {
        return this.updateSql;
    }

    @Override
    public String getExistsSql() {
        return this.existsSql;
    }

    public String toString() {
        return "TableSql [insertPlaceholders=" + this.insertPlaceholders + ", mergePlaceholders=" + this.mergePlaceholders + ", selectByPrimaryKeySql=" + this.selectByPrimaryKeySql + ", selectAllSql=" + this.selectAllSql + ", insertSql=" + this.insertSql + ", updateSql=" + this.updateSql + ", deleteSql=" + this.deleteSql + ", mergeSql=" + this.mergeSql + ", existsSql=" + this.existsSql + ", insertSqlPrefix=" + this.insertSqlPrefix + ", mergeSqlPrefix=" + this.mergeSqlPrefix + "]";
    }

    @Override
    public String getUpdateSql(RowMap object) {
        return this.updateSqlFactory.createUpdateSql(object.keySet());
    }
}

