/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.context.logging;

import java.sql.Connection;
import org.nkjmlab.sorm4j.context.logging.SormLogger;
import org.nkjmlab.sorm4j.sql.parameterize.ParameterizedSql;

public final class LogPoint {
    private final String name;
    private final SormLogger logger;
    private long startTime;

    LogPoint(String name, SormLogger logger) {
        this.name = name;
        this.logger = logger;
    }

    private long getElapsedTime() {
        return System.nanoTime() - this.startTime;
    }

    public String getTag() {
        return this.name + ":" + this.hashCode() / 10000;
    }

    public void logAfterMultiRow(int[] result) {
        this.logger.logAfterMultiRow(this.name, this.getElapsedTime(), result);
    }

    public void logAfterQuery(Object ret) {
        this.logger.logAfterQuery(this.getTag(), this.getElapsedTime(), ret);
    }

    public void logAfterUpdate(int ret) {
        this.logger.logAfterUpdate(this.name, this.getElapsedTime(), ret);
    }

    public void logBeforeMultiRow(Connection con, Class<?> objectClass, int length, String tableName) {
        this.logger.logBeforeMultiRow(this.getTag(), con, objectClass, length, tableName);
        this.startTime = System.nanoTime();
    }

    public void logBeforeSql(Connection connection, ParameterizedSql sql) {
        this.logger.logBeforeSql(this.getTag(), connection, sql);
        this.startTime = System.nanoTime();
    }

    public void logBeforeSql(Connection connection, String sql, Object ... parameters) {
        this.logger.logBeforeSql(this.getTag(), connection, sql, parameters);
        this.startTime = System.nanoTime();
    }

    public void logMapping(String mappingInfo) {
        this.logger.logMapping(this.getTag(), mappingInfo);
    }
}

