/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.common.exception.SormException;
import org.nkjmlab.sorm4j.context.SormContext;
import org.nkjmlab.sorm4j.internal.context.impl.ContainerAccessor;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;

public final class ColumnToAccessorMapping {
    private final Map<String, ContainerAccessor> columnToAccessorMap;
    private final Map<String, ContainerAccessor> aliasColumnToAccessorMap;
    private final String columnAliasPrefix;

    public ColumnToAccessorMapping(Class<?> objectClass, Map<String, ContainerAccessor> columnToAccessorMap, String columnAliasPrefix) {
        this.columnToAccessorMap = columnToAccessorMap.entrySet().stream().collect(Collectors.toMap(e -> SormContext.getDefaultCanonicalStringCache().toCanonicalName((String)e.getKey()), e -> (ContainerAccessor)e.getValue()));
        this.columnAliasPrefix = columnAliasPrefix;
        this.aliasColumnToAccessorMap = columnAliasPrefix == null || columnAliasPrefix.length() == 0 ? Collections.emptyMap() : this.createAliasAccessors(columnAliasPrefix, columnToAccessorMap).entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (ContainerAccessor)e.getValue()));
    }

    public ContainerAccessor get(String columnName) {
        String cn = SormContext.getDefaultCanonicalStringCache().toCanonicalName(columnName);
        ContainerAccessor ret = this.columnToAccessorMap.get(cn);
        return ret != null ? ret : this.aliasColumnToAccessorMap.get(cn);
    }

    public String toString() {
        List keySet = this.columnToAccessorMap.keySet().stream().sorted().collect(Collectors.toList());
        List aliasKeySet = this.aliasColumnToAccessorMap.keySet().stream().sorted().collect(Collectors.toList());
        return "columns " + String.valueOf(keySet) + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), keySet.stream().map(e -> "  CsvColumn " + e + " <=> " + this.columnToAccessorMap.get(e).getFormattedString()).collect(Collectors.toList())) + System.lineSeparator() + "column aliases " + String.valueOf(aliasKeySet) + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), aliasKeySet.stream().map(e -> "  CsvColumn " + e + " <=> " + this.aliasColumnToAccessorMap.get(e).getFormattedString()).collect(Collectors.toList()));
    }

    public String getColumnAliasPrefix() {
        return this.columnAliasPrefix;
    }

    public final void setValue(Object object, String columnName, Object value) {
        ContainerAccessor acc = this.get(columnName);
        if (acc == null) {
            Object[] params = new Object[]{value, value.getClass().getSimpleName(), object.getClass().getName(), columnName, this.columnToAccessorMap.toString()};
            throw new SormException(ParameterizedStringFormatter.LENGTH_256.format("Error: setting value [{}] of type [{}] in [{}] because column [{}] does not have a corresponding setter method or field access =>[{}]", params));
        }
        try {
            acc.set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Object[] params = new Object[]{columnName, object == null ? "null" : object.getClass().getSimpleName(), acc.getFormattedString(), value};
            throw new SormException(ParameterizedStringFormatter.LENGTH_256.format("Could not set a value for column [{}] to instance of [{}] with [{}]. The value is=[{}]", params), e);
        }
    }

    private final ContainerAccessor getAccessor(Object object, String columnName) {
        ContainerAccessor acc = this.get(columnName);
        if (acc == null) {
            Object[] params = new Object[]{object.getClass(), columnName, this};
            throw new SormException(ParameterizedStringFormatter.LENGTH_256.format("Error: getting value from [{}] because column [{}] does not have a corresponding getter method or field access. {}", params));
        }
        return acc;
    }

    public final Object getValue(Object object, String columnName) {
        ContainerAccessor acc = this.getAccessor(object, columnName);
        try {
            return acc.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Object[] params = new Object[]{object == null ? "null" : object.getClass().getName(), acc.getFormattedString(), acc.getFormattedString(), object};
            throw new SormException(ParameterizedStringFormatter.LENGTH_256.format("Could not get a value from instance of [{}] for column [{}] with [{}] The instance is =[{}]", params), e);
        }
    }

    private Map<String, ContainerAccessor> createAliasAccessors(String prefix, Map<String, ContainerAccessor> accessors) {
        if (prefix.length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, ContainerAccessor> ret = new HashMap<String, ContainerAccessor>();
        for (String key : accessors.keySet()) {
            String aKey = SormContext.getDefaultCanonicalStringCache().toCanonicalNameWithTableName(prefix, key);
            if (accessors.containsKey(aKey)) {
                Object[] params = new Object[]{prefix, key};
                throw new SormException(ParameterizedStringFormatter.LENGTH_256.format("Modify table alias because table alias [{}] and column [{}] is concatenated and it becomes duplicated column", params));
            }
            ret.put(aKey, accessors.get(key));
        }
        return ret;
    }
}

