/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping.multirow;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.nkjmlab.sorm4j.context.logging.LogContext;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.context.PreparedStatementSupplier;
import org.nkjmlab.sorm4j.internal.context.SqlParametersSetter;
import org.nkjmlab.sorm4j.internal.context.logging.LogPoint;
import org.nkjmlab.sorm4j.internal.mapping.ContainerToTableMapper;
import org.nkjmlab.sorm4j.internal.mapping.multirow.BatchHelper;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.sql.TableSql;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public abstract class MultiRowProcessorBase<T>
implements MultiRowProcessor<T> {
    private final int batchSize;
    private final PreparedStatementSupplier statementSupplier;
    private final SqlParametersSetter sqlParametersSetter;
    private final ContainerToTableMapper<T> tableMapping;
    private final LogContext loggerContext;

    MultiRowProcessorBase(LogContext loggerContext, SqlParametersSetter sqlParametersSetter, PreparedStatementSupplier statementSupplier, ContainerToTableMapper<T> tableMapping, int batchSize) {
        this.loggerContext = loggerContext;
        this.statementSupplier = statementSupplier;
        this.sqlParametersSetter = sqlParametersSetter;
        this.tableMapping = tableMapping;
        this.batchSize = batchSize;
    }

    @Override
    public abstract int[] multiRowInsert(Connection var1, T[] var2);

    @Override
    public abstract int[] multiRowMerge(Connection var1, T[] var2);

    protected final TableSql getSql() {
        return this.tableMapping.getSql();
    }

    protected Object[] getInsertParameters(T obj) {
        return this.tableMapping.getInsertParameters(obj);
    }

    protected Object[] getMergeParameters(T obj) {
        return this.tableMapping.getMergeParameters(obj);
    }

    @Override
    public final void setPrametersOfMultiRow(PreparedStatement stmt, T[] objects) throws SQLException {
        Object[] parameters = Arrays.stream(objects).flatMap(obj -> Arrays.stream(this.tableMapping.getParametersWithoutAutoGeneratedColumns(obj))).toArray(Object[]::new);
        this.sqlParametersSetter.setParameters(stmt, parameters);
    }

    @Override
    public final int[] batch(Connection con, String sql, Function<T, Object[]> parameterCreator, T[] objects) {
        return this.execMultiRowProcIfValidObjects(con, objects, nonNullObjects -> {
            int[] result = new int[]{};
            boolean origAutoCommit = OrmConnectionImpl.getAutoCommit(con);
            try {
                int[] nArray;
                block12: {
                    PreparedStatement stmt = this.statementSupplier.prepareStatement(con, sql);
                    try {
                        OrmConnectionImpl.setAutoCommit(con, false);
                        BatchHelper batchHelper = new BatchHelper(this.batchSize, stmt);
                        for (int i = 0; i < objects.length; ++i) {
                            Object obj = objects[i];
                            this.sqlParametersSetter.setParameters(stmt, (Object[])parameterCreator.apply(obj));
                            batchHelper.addBatchAndExecuteIfReachedThreshold();
                        }
                        nArray = result = batchHelper.finish();
                        if (stmt == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw Try.rethrow(e);
                        }
                    }
                    stmt.close();
                }
                return nArray;
            }
            finally {
                OrmConnectionImpl.commitOrRollback(con, origAutoCommit);
                OrmConnectionImpl.setAutoCommit(con, origAutoCommit);
            }
        });
    }

    final int[] execMultiRowProcIfValidObjects(Connection con, T[] objects, Function<T[], int[]> exec) {
        if (objects == null || objects.length == 0) {
            return new int[0];
        }
        Optional<LogPoint> lp = this.loggerContext.createLogPoint(LogContext.Category.EXECUTE_MULTI_ROW_UPDATE, MultiRowProcessorBase.class);
        lp.ifPresent(_lp -> _lp.logBeforeMultiRow(con, objects[0].getClass(), objects.length, this.tableMapping.getTableMetaData().getTableName()));
        int[] result = exec.apply(objects);
        lp.ifPresent(_lp -> _lp.logAfterMultiRow(result));
        return result;
    }

    protected PreparedStatement prepareStatement(Connection con, String sql) throws SQLException {
        return this.statementSupplier.prepareStatement(con, sql);
    }
}

