/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.sql.metadata.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.internal.sql.metadata.jdbc.JdbcColumnMetaDataImpl;
import org.nkjmlab.sorm4j.internal.sql.metadata.jdbc.JdbcForeignKeyMetaDataImpl;
import org.nkjmlab.sorm4j.internal.sql.metadata.jdbc.JdbcIndexMetaDataImpl;
import org.nkjmlab.sorm4j.internal.sql.metadata.jdbc.JdbcTableMetaDataImpl;
import org.nkjmlab.sorm4j.sql.metadata.jdbc.JdbcColumnMetaData;
import org.nkjmlab.sorm4j.sql.metadata.jdbc.JdbcDatabaseMetaData;
import org.nkjmlab.sorm4j.sql.metadata.jdbc.JdbcForeignKeyMetaData;
import org.nkjmlab.sorm4j.sql.metadata.jdbc.JdbcIndexMetaData;
import org.nkjmlab.sorm4j.sql.metadata.jdbc.JdbcTableMetaData;

public final class JdbcDatabaseMetaDataImpl
implements JdbcDatabaseMetaData {
    private final String databaseProductName;
    private final String databaseProductVersion;
    private final String driverName;
    private final String driverVersion;
    private final String url;
    private final String userName;
    private final int jdbcMajorVersion;
    private final int jdbcMinorVersion;
    private final int defaultTransactionIsolation;
    private final int maxConnections;
    private final String searchStringEscape;
    private final String sqlKeywords;
    private final String numericFunctions;
    private final String stringFunctions;
    private final String systemFunctions;
    private final String timeDateFunctions;
    private final boolean supportsTransactions;
    private final boolean supportsBatchUpdates;
    private final boolean supportsStoredProcedures;
    private final Map<JdbcDatabaseMetaData.TableName, JdbcTableMetaData> jdbcTablesMetaData;
    private final Map<JdbcDatabaseMetaData.TableName, Map<String, JdbcIndexMetaData>> jdbcIndexesMetaData;
    private final Map<JdbcDatabaseMetaData.TableName, List<JdbcColumnMetaData>> columnsMetaData;
    private final List<JdbcDatabaseMetaData.TableName> tableNames;
    private final Map<String, String> schemasMetaData;
    private final Map<JdbcDatabaseMetaData.TableName, List<String>> primaryKeysMetaData;
    private final Map<JdbcDatabaseMetaData.TableName, List<JdbcForeignKeyMetaData>> foreignKeysMetaData;

    public JdbcDatabaseMetaDataImpl(String databaseProductName, String databaseProductVersion, String driverName, String driverVersion, int jdbcMajorVersion, int jdbcMinorVersion, int defaultTransactionIsolation, int maxConnections, String url, String userName, String searchStringEscape, String sqlKeywords, String numericFunctions, String stringFunctions, String systemFunctions, String timeDateFunctions, boolean supportsTransactions, boolean supportsBatchUpdates, boolean supportsStoredProcedures, Map<String, String> schemasMetaData, Map<JdbcDatabaseMetaData.TableName, List<String>> primaryKeysMetaData, Map<JdbcDatabaseMetaData.TableName, List<JdbcForeignKeyMetaData>> foreignKeysMetaData, Map<JdbcDatabaseMetaData.TableName, JdbcTableMetaData> tablesMetaData, Map<JdbcDatabaseMetaData.TableName, Map<String, JdbcIndexMetaData>> indexesMetaData, Map<JdbcDatabaseMetaData.TableName, List<JdbcColumnMetaData>> columnsMetaData) {
        this.databaseProductName = databaseProductName;
        this.databaseProductVersion = databaseProductVersion;
        this.driverName = driverName;
        this.driverVersion = driverVersion;
        this.jdbcMajorVersion = jdbcMajorVersion;
        this.jdbcMinorVersion = jdbcMinorVersion;
        this.defaultTransactionIsolation = defaultTransactionIsolation;
        this.maxConnections = maxConnections;
        this.url = url;
        this.userName = userName;
        this.searchStringEscape = searchStringEscape;
        this.sqlKeywords = sqlKeywords;
        this.numericFunctions = numericFunctions;
        this.stringFunctions = stringFunctions;
        this.systemFunctions = systemFunctions;
        this.timeDateFunctions = timeDateFunctions;
        this.supportsTransactions = supportsTransactions;
        this.supportsBatchUpdates = supportsBatchUpdates;
        this.supportsStoredProcedures = supportsStoredProcedures;
        this.jdbcTablesMetaData = tablesMetaData;
        this.jdbcIndexesMetaData = indexesMetaData;
        this.columnsMetaData = columnsMetaData;
        this.schemasMetaData = schemasMetaData;
        this.primaryKeysMetaData = primaryKeysMetaData;
        this.foreignKeysMetaData = foreignKeysMetaData;
        this.tableNames = tablesMetaData.keySet().stream().collect(Collectors.toList());
    }

    @Override
    public Map<JdbcDatabaseMetaData.TableName, List<JdbcColumnMetaData>> getJdbcColumnsMetaData() {
        return this.columnsMetaData;
    }

    @Override
    public String getSqlKeywords() {
        return this.sqlKeywords;
    }

    @Override
    public String getNumericFunctions() {
        return this.numericFunctions;
    }

    @Override
    public String getStringFunctions() {
        return this.stringFunctions;
    }

    @Override
    public String getSystemFunctions() {
        return this.systemFunctions;
    }

    @Override
    public String getTimeDateFunctions() {
        return this.timeDateFunctions;
    }

    @Override
    public boolean isSupportsTransactions() {
        return this.supportsTransactions;
    }

    @Override
    public boolean isSupportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    @Override
    public boolean isSupportsStoredProcedures() {
        return this.supportsStoredProcedures;
    }

    @Override
    public Map<String, String> getSchemasMetaData() {
        return this.schemasMetaData;
    }

    @Override
    public Map<JdbcDatabaseMetaData.TableName, List<String>> getPrimaryKeysMetaData() {
        return this.primaryKeysMetaData;
    }

    @Override
    public Map<JdbcDatabaseMetaData.TableName, List<JdbcForeignKeyMetaData>> getJdbcForeignKeysMetaData() {
        return this.foreignKeysMetaData;
    }

    @Override
    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public String getDriverVersion() {
        return this.driverVersion;
    }

    @Override
    public int getJdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    @Override
    public int getJdbcMinorVersion() {
        return this.jdbcMinorVersion;
    }

    @Override
    public String getSearchStringEscape() {
        return this.searchStringEscape;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public Map<JdbcDatabaseMetaData.TableName, JdbcTableMetaData> getJdbcTablesMetaData() {
        return this.jdbcTablesMetaData;
    }

    @Override
    public Map<JdbcDatabaseMetaData.TableName, Map<String, JdbcIndexMetaData>> getJdbcIndexesMetaData() {
        return this.jdbcIndexesMetaData;
    }

    @Override
    public List<JdbcDatabaseMetaData.TableName> getTableNames() {
        return this.tableNames;
    }

    public String toString() {
        return "JdbcDatabaseMetaData [databaseProductName=" + this.databaseProductName + ", databaseProductVersion=" + this.databaseProductVersion + ", driverName=" + this.driverName + ", driverVersion=" + this.driverVersion + ", url=" + this.url + ", userName=" + this.userName + ", driverVersion=" + this.driverVersion + ", jdbcMajorVersion=" + this.jdbcMajorVersion + ", jdbcMinorVersion=" + this.jdbcMinorVersion + ", defaultTransactionIsolation=" + this.defaultTransactionIsolation + ", maxConnections=" + this.maxConnections + ", searchStringEscape=" + this.searchStringEscape + ", sqlKeywords=" + this.sqlKeywords + ", numericFunctions=" + this.numericFunctions + ", stringFunctions=" + this.stringFunctions + ", systemFunctions=" + this.systemFunctions + ", timeDateFunctions=" + this.timeDateFunctions + ", supportsTransactions=" + this.supportsTransactions + ", supportsBatchUpdates=" + this.supportsBatchUpdates + ", supportsStoredProcedures=" + this.supportsStoredProcedures + ", jdbcTablesMetaData=" + String.valueOf(this.jdbcTablesMetaData) + ", jdbcIndexesMetaData=" + String.valueOf(this.jdbcIndexesMetaData) + ", columnsMetaData=" + String.valueOf(this.columnsMetaData) + ", tableNames=" + String.valueOf(this.tableNames) + ", schemasMetaData=" + String.valueOf(this.schemasMetaData) + ", primaryKeysMetaData=" + String.valueOf(this.primaryKeysMetaData) + ", foreignKeysMetaData=" + String.valueOf(this.foreignKeysMetaData) + "]";
    }

    public static JdbcDatabaseMetaData of(DatabaseMetaData metaData) throws SQLException {
        try (ResultSet resultSet = metaData.getTables(null, "PUBLIC", null, new String[]{"TABLE", "VIEW"});){
            Map<JdbcDatabaseMetaData.TableName, JdbcTableMetaData> tables = JdbcDatabaseMetaDataImpl.mapColumnsInResultSetToMap(resultSet, List.of("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION")).stream().map(e -> new JdbcTableMetaDataImpl((Map<String, Object>)e)).collect(Collectors.toMap(m -> JdbcDatabaseMetaData.TableName.of(m.getTableName()), m -> m, (v1, v2) -> v1));
            HashMap<JdbcDatabaseMetaData.TableName, List<JdbcColumnMetaData>> columns = new HashMap<JdbcDatabaseMetaData.TableName, List<JdbcColumnMetaData>>();
            HashMap<JdbcDatabaseMetaData.TableName, Map<String, JdbcIndexMetaData>> indexes = new HashMap<JdbcDatabaseMetaData.TableName, Map<String, JdbcIndexMetaData>>();
            for (Map.Entry<JdbcDatabaseMetaData.TableName, JdbcTableMetaData> jdbcTableEntry : tables.entrySet()) {
                JdbcDatabaseMetaData.TableName tableName = jdbcTableEntry.getKey();
                columns.put(tableName, JdbcDatabaseMetaDataImpl.getColumnsMetaData(metaData, tableName.getName()));
                ResultSet indexInfo = metaData.getIndexInfo(null, null, tableName.getName(), false, false);
                try {
                    Map<String, JdbcIndexMetaData> l = JdbcDatabaseMetaDataImpl.mapColumnsInResultSetToMap(indexInfo, List.of("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION")).stream().map(e -> new JdbcIndexMetaDataImpl((Map<String, Object>)e)).collect(Collectors.toMap(m -> m.getIndexName(), m -> m, (v1, v2) -> v1));
                    indexes.put(tableName, l);
                }
                finally {
                    if (indexInfo == null) continue;
                    indexInfo.close();
                }
            }
            JdbcDatabaseMetaDataImpl jdbcDatabaseMetaDataImpl = new JdbcDatabaseMetaDataImpl(metaData.getDatabaseProductName(), metaData.getDatabaseProductVersion(), metaData.getDriverName(), metaData.getDriverVersion(), metaData.getJDBCMajorVersion(), metaData.getJDBCMinorVersion(), metaData.getDefaultTransactionIsolation(), metaData.getMaxConnections(), metaData.getURL(), metaData.getUserName(), metaData.getSearchStringEscape(), metaData.getSQLKeywords(), metaData.getNumericFunctions(), metaData.getStringFunctions(), metaData.getSystemFunctions(), metaData.getTimeDateFunctions(), metaData.supportsTransactions(), metaData.supportsBatchUpdates(), metaData.supportsStoredProcedures(), JdbcDatabaseMetaDataImpl.mapSchemas(metaData.getSchemas()), JdbcDatabaseMetaDataImpl.mapPrimaryKeys(metaData), JdbcDatabaseMetaDataImpl.mapForeignKeys(metaData), tables, indexes, columns);
            return jdbcDatabaseMetaDataImpl;
        }
    }

    private static Map<String, String> mapSchemas(ResultSet schemas) throws SQLException {
        HashMap<String, String> schemaMap = new HashMap<String, String>();
        while (schemas.next()) {
            String schemaName = schemas.getString("TABLE_SCHEM");
            String catalogName = schemas.getString("TABLE_CATALOG");
            schemaMap.put(schemaName, catalogName);
        }
        return schemaMap;
    }

    private static Map<JdbcDatabaseMetaData.TableName, List<String>> mapPrimaryKeys(DatabaseMetaData metaData) throws SQLException {
        HashMap<JdbcDatabaseMetaData.TableName, List<String>> primaryKeys = new HashMap<JdbcDatabaseMetaData.TableName, List<String>>();
        ResultSet pkResultSet = metaData.getTables(null, null, "%", new String[]{"TABLE"});
        while (pkResultSet.next()) {
            String tableName = pkResultSet.getString("TABLE_NAME");
            ArrayList<String> pkColumns = new ArrayList<String>();
            try (ResultSet pkColumnsResultSet = metaData.getPrimaryKeys(null, null, tableName);){
                while (pkColumnsResultSet.next()) {
                    pkColumns.add(pkColumnsResultSet.getString("COLUMN_NAME"));
                }
            }
            primaryKeys.put(JdbcDatabaseMetaData.TableName.of(tableName), pkColumns);
        }
        return primaryKeys;
    }

    private static Map<JdbcDatabaseMetaData.TableName, List<JdbcForeignKeyMetaData>> mapForeignKeys(DatabaseMetaData metaData) throws SQLException {
        HashMap<JdbcDatabaseMetaData.TableName, List<JdbcForeignKeyMetaData>> foreignKeys = new HashMap<JdbcDatabaseMetaData.TableName, List<JdbcForeignKeyMetaData>>();
        ResultSet tablesResultSet = metaData.getTables(null, null, "%", new String[]{"TABLE"});
        while (tablesResultSet.next()) {
            String tableName = tablesResultSet.getString("TABLE_NAME");
            ArrayList<JdbcForeignKeyMetaDataImpl> fkList = new ArrayList<JdbcForeignKeyMetaDataImpl>();
            try (ResultSet fkResultSet = metaData.getImportedKeys(null, null, tableName);){
                while (fkResultSet.next()) {
                    fkList.add(new JdbcForeignKeyMetaDataImpl(fkResultSet.getString("FKTABLE_NAME"), fkResultSet.getString("FKCOLUMN_NAME"), fkResultSet.getString("PKTABLE_NAME"), fkResultSet.getString("PKCOLUMN_NAME"), fkResultSet.getShort("UPDATE_RULE"), fkResultSet.getShort("DELETE_RULE")));
                }
            }
            foreignKeys.put(JdbcDatabaseMetaData.TableName.of(tableName), fkList);
        }
        return foreignKeys;
    }

    private static List<Map<String, Object>> mapColumnsInResultSetToMap(ResultSet resultSet, List<String> columns) throws SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        while (resultSet.next()) {
            LinkedHashMap tmp = new LinkedHashMap();
            columns.forEach(col -> {
                try {
                    tmp.put(col, resultSet.getObject((String)col));
                }
                catch (SQLException e) {
                    tmp.put(col, null);
                }
            });
            result.add(tmp);
        }
        return result;
    }

    private static String getSchemaPattern(DatabaseMetaData metaData) throws SQLException {
        return "Oracle".equalsIgnoreCase(metaData.getDatabaseProductName()) ? "%" : null;
    }

    public static List<JdbcColumnMetaData> getColumnsMetaData(DatabaseMetaData metaData, String _tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, JdbcDatabaseMetaDataImpl.getSchemaPattern(metaData), _tableName, "%");){
            ArrayList<JdbcColumnMetaData> columnsList = new ArrayList<JdbcColumnMetaData>();
            while (resultSet.next()) {
                String tableCatalog = resultSet.getString(1);
                String tableSchema = resultSet.getString(2);
                String tableName = resultSet.getString(3);
                String columnName = resultSet.getString(4);
                int dataType = resultSet.getInt(5);
                String typeName = resultSet.getString(6);
                int columnSize = resultSet.getInt(7);
                int decimalDigits = resultSet.getInt(9);
                int numPrecRadix = resultSet.getInt(10);
                int nullableFlag = resultSet.getInt(11);
                String remarks = resultSet.getString(12);
                String columnDefault = resultSet.getString(13);
                int charOctetLength = resultSet.getInt(16);
                int ordinalPosition = resultSet.getInt(17);
                String isNullable = resultSet.getString(18);
                String isAutoIncremented = resultSet.getString(23);
                String isGenerated = resultSet.getString(24);
                columnsList.add(new JdbcColumnMetaDataImpl(tableCatalog, tableSchema, tableName, columnName, dataType, typeName, columnSize, numPrecRadix, decimalDigits, ordinalPosition, nullableFlag, charOctetLength, isNullable, columnDefault, remarks, isAutoIncremented, isGenerated));
            }
            ArrayList<JdbcColumnMetaData> arrayList = columnsList;
            return arrayList;
        }
    }
}

