/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.sql.parameterize;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nkjmlab.sorm4j.common.container.RowMap;
import org.nkjmlab.sorm4j.context.SormContext;
import org.nkjmlab.sorm4j.internal.context.ColumnToFieldAccessorMapper;
import org.nkjmlab.sorm4j.internal.context.impl.ContainerAccessor;
import org.nkjmlab.sorm4j.internal.context.impl.DefaultColumnToFieldAccessorMapper;
import org.nkjmlab.sorm4j.internal.sql.parameterize.ParameterizedSqlImpl;
import org.nkjmlab.sorm4j.sql.parameterize.NamedParameterSqlBuilder;
import org.nkjmlab.sorm4j.sql.parameterize.ParameterizedSql;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public final class NamedParameterSqlBuilderImpl
implements NamedParameterSqlBuilder {
    private static final String DEFAULT_NAMED_PARAMETER_PREFIX = ":";
    private static final Pattern pattern = Pattern.compile(":([a-zA-Z0-9_]+)");
    private static final Map<Class<?>, Map<String, ContainerAccessor>> nameToFieldMaps = new ConcurrentHashMap();
    private static final ColumnToFieldAccessorMapper DEFAULT_COLUMN_FIELD_MAPPER = new DefaultColumnToFieldAccessorMapper();
    private final String sql;
    private final RowMap parameters;
    private final List<String> parameterNames;

    public NamedParameterSqlBuilderImpl(String sql) {
        this.sql = sql;
        this.parameters = RowMap.of(new Map.Entry[0]);
        this.parameterNames = NamedParameterSqlBuilderImpl.extractParameterNames(sql);
    }

    @Override
    public NamedParameterSqlBuilder bindParameters(Map<String, Object> namedParams) {
        this.parameters.putAll(namedParams);
        return this;
    }

    @Override
    public NamedParameterSqlBuilder bindParameter(String key, Object value) {
        this.parameters.put(key, value);
        return this;
    }

    @Override
    public NamedParameterSqlBuilder bindParameters(Object parametersContainer) {
        this.parameterNames.forEach(parameterName -> {
            ContainerAccessor acc = this.getAccessor(parametersContainer, (String)parameterName);
            if (acc != null) {
                this.parameters.put(parameterName, Try.getOrElseNull(() -> acc.get(parametersContainer)));
            }
        });
        return this;
    }

    @Override
    public ParameterizedSql build() {
        List<Object> orderedParams = this.parameterNames.stream().map(e -> this.getParam((String)e)).toList();
        return ParameterizedSqlImpl.of(this.replaceNamedParameterToPlaceholder(this.sql), orderedParams.toArray());
    }

    private Object getParam(String parameterName) {
        return this.parameters.get(parameterName);
    }

    private ContainerAccessor getAccessor(Object parametersContainer, String parameterName) {
        Class<?> objectClass = parametersContainer.getClass();
        return (ContainerAccessor)nameToFieldMaps.computeIfAbsent(objectClass, k -> DEFAULT_COLUMN_FIELD_MAPPER.createMapping(objectClass)).get(SormContext.getDefaultCanonicalStringCache().toCanonicalName(parameterName));
    }

    private static List<String> extractParameterNames(String sql) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        Matcher matcher = pattern.matcher(sql);
        while (matcher.find()) {
            parameterNames.add(matcher.group(1));
        }
        return parameterNames;
    }

    private String replaceNamedParameterToPlaceholder(String sql) {
        Matcher matcher = pattern.matcher(sql);
        StringBuffer replacedSql = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(replacedSql, "?");
        }
        matcher.appendTail(replacedSql);
        return replacedSql.toString();
    }
}

