/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.sql.parameterize;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nkjmlab.sorm4j.common.exception.SormException;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;
import org.nkjmlab.sorm4j.sql.parameterize.ParameterizedSql;
import org.nkjmlab.sorm4j.sql.statement.SqlStringUtils;

public final class ParameterizedSqlImpl
implements ParameterizedSql {
    private final String sql;
    private final Object[] parameters;
    private static char LIST_PLACEHOLDER_LEFT = (char)60;
    private static char LIST_PLACEHOLDER_CENTER = (char)63;
    private static char LIST_PLACEHOLDER_RIGHT = (char)62;
    private static final String LIST_PLACEHOLDER = "" + LIST_PLACEHOLDER_LEFT + LIST_PLACEHOLDER_CENTER + LIST_PLACEHOLDER_RIGHT;

    private ParameterizedSqlImpl(String sql, Object ... parameters) {
        this.sql = sql;
        this.parameters = parameters;
    }

    public String toString() {
        return "sql=[" + this.sql + "]" + (String)(this.parameters == null || this.parameters.length == 0 ? "" : ", parameters=" + Arrays.toString(this.parameters));
    }

    @Override
    public final String getSql() {
        return this.sql;
    }

    @Override
    public final Object[] getParameters() {
        return this.parameters;
    }

    public static ParameterizedSql of(String sql, Object ... parameters) {
        return sql.contains(LIST_PLACEHOLDER) ? ListPlaceholdersHandler.createExpandedListPlaceholdersSql(sql, parameters) : new ParameterizedSqlImpl(sql, parameters);
    }

    @Override
    public String getExecutableSql() {
        String result = this.sql;
        String regex = "(?<!\\w)\\?(?!\\w)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(result);
        int paramIndex = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find() && paramIndex < this.parameters.length) {
            matcher.appendReplacement(sb, SqlStringUtils.literal(this.parameters[paramIndex++]));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static class ListPlaceholdersHandler {
        private ListPlaceholdersHandler() {
        }

        private static ParameterizedSql createExpandedListPlaceholdersSql(String sql, Object[] parameters) {
            List<Integer> specialParameterIndexes = ListPlaceholdersHandler.createSpecialParameterIndexes(sql, LIST_PLACEHOLDER_LEFT, LIST_PLACEHOLDER_CENTER, LIST_PLACEHOLDER_RIGHT);
            ArrayList<Object> flattenListParams = new ArrayList<Object>();
            for (int i = 0; i < parameters.length; ++i) {
                if (specialParameterIndexes.contains(i)) {
                    Object o = parameters[i];
                    if (o instanceof Collection) {
                        ((Collection)o).forEach(p -> flattenListParams.add(p));
                        continue;
                    }
                    if (o.getClass().isArray()) {
                        int length = Array.getLength(o);
                        for (int j = 0; j < length; ++j) {
                            Object elem = Array.get(o, j);
                            flattenListParams.add(elem);
                        }
                        continue;
                    }
                    throw new SormException(LIST_PLACEHOLDER + " parameter should be bind Collection or Array");
                }
                flattenListParams.add(parameters[i]);
            }
            String _sql = ParameterizedStringFormatter.newString(sql, LIST_PLACEHOLDER, specialParameterIndexes.size(), index -> {
                int parameterLength = ListPlaceholdersHandler.getSize(parameters[(Integer)specialParameterIndexes.get((int)index)]);
                return "?,".repeat(parameterLength).substring(0, 2 * parameterLength - 1);
            });
            return new ParameterizedSqlImpl(_sql, flattenListParams.toArray());
        }

        private static int getSize(Object object) {
            if (object instanceof Collection) {
                return ((Collection)object).size();
            }
            if (object.getClass().isArray()) {
                return Array.getLength(object);
            }
            throw new SormException(LIST_PLACEHOLDER + " parameter should be bind Collection or Array");
        }

        private static List<Integer> createSpecialParameterIndexes(String str, char prefix, char normalPlaceholder, char suffix) {
            char[] arry = str.toCharArray();
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int parameterIndex = 0;
            for (int i = 0; i < arry.length; ++i) {
                char c = arry[i];
                if (c == normalPlaceholder && i - 1 >= 0 && arry[i - 1] == prefix && i + 1 < arry.length && arry[i + 1] == suffix) {
                    ret.add(parameterIndex);
                    ++parameterIndex;
                    continue;
                }
                if (c != normalPlaceholder) continue;
                ++parameterIndex;
            }
            return ret;
        }
    }
}

