/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.sql.result;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.common.container.RowMap;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;

public class BasicRowMap
implements RowMap {
    private final LinkedHashMap<String, Object> map;

    public BasicRowMap() {
        this.map = new LinkedHashMap();
    }

    public BasicRowMap(int initialCapacity, float loadFactor) {
        this.map = new LinkedHashMap(initialCapacity, loadFactor);
    }

    public BasicRowMap(Map<String, Object> map) {
        this.map = List.copyOf(map.entrySet()).stream().collect(LinkedHashMap::new, (m, v) -> m.put(BasicRowMap.toKey((String)v.getKey()), v.getValue()), HashMap::putAll);
    }

    private static String toKey(String key) {
        return RowMap.toKey(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(BasicRowMap.toKey(key.toString()));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(BasicRowMap.toKey(key.toString()));
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(BasicRowMap.toKey(key), value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(BasicRowMap.toKey(key.toString()));
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        m.entrySet().forEach((? super T en) -> this.map.put(BasicRowMap.toKey((String)en.getKey()), en.getValue()));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        return Objects.equals(this.map, other);
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public String getString(String key) {
        return this.getHelper(key, String.class, val -> byte[].class.isInstance(val) ? new String((byte[])val) : val.toString());
    }

    @Override
    public Integer getInteger(String key) {
        return this.getHelper(key, Integer.class, val -> Number.class.isInstance(val) ? ((Number)val).intValue() : Integer.valueOf(val.toString()).intValue());
    }

    @Override
    public Long getLong(String key) {
        return this.getHelper(key, Long.class, val -> Number.class.isInstance(val) ? ((Number)val).longValue() : Long.valueOf(val.toString()).longValue());
    }

    @Override
    public Float getFloat(String key) {
        return this.getHelper(key, Float.class, val -> Float.valueOf(Number.class.isInstance(val) ? ((Number)val).floatValue() : Float.valueOf(val.toString()).floatValue()));
    }

    @Override
    public Double getDouble(String key) {
        return this.getHelper(key, Double.class, val -> Number.class.isInstance(val) ? ((Number)val).doubleValue() : Double.valueOf(val.toString()).doubleValue());
    }

    private <T> T getHelper(String key, Class<T> toType, Function<Object, T> converter) {
        Object val = this.get(key);
        if (val == null) {
            return null;
        }
        if (toType.isInstance(val)) {
            return toType.cast(val);
        }
        return converter.apply(val);
    }

    @Override
    public LocalDate getLocalDate(String key) {
        return this.getHelper(key, LocalDate.class, val -> Date.class.isInstance(val) ? ((Date)val).toLocalDate() : LocalDate.parse(val.toString()));
    }

    @Override
    public LocalTime getLocalTime(String key) {
        return this.getHelper(key, LocalTime.class, val -> Date.class.isInstance(val) ? ((Time)val).toLocalTime() : LocalTime.parse(val.toString()));
    }

    @Override
    public LocalDateTime getLocalDateTime(String key) {
        return this.getHelper(key, LocalDateTime.class, val -> Timestamp.class.isInstance(val) ? ((Timestamp)val).toLocalDateTime() : LocalDateTime.parse(val.toString()));
    }

    @Override
    public <T> T[] getArray(String key, Class<T> componentType) {
        Object val = this.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Object[] && componentType.isAssignableFrom(val.getClass().getComponentType())) {
            return (Object[])val;
        }
        return ArrayUtils.convertToObjectArray(componentType, val);
    }

    @Override
    public List<Object> getObjectList(String ... keys) {
        return Arrays.stream(keys).map(key -> this.get(key)).collect(Collectors.toList());
    }

    @Override
    public List<String> getStringList(String ... keys) {
        return Arrays.stream(keys).map(key -> this.getString((String)key)).collect(Collectors.toList());
    }

    @Override
    public Object getObject(String key) {
        return this.get(key);
    }
}

