/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.sql.result;

import java.util.Collections;
import java.util.List;
import org.nkjmlab.sorm4j.Orm;
import org.nkjmlab.sorm4j.table.definition.TableDefinition;

public final class TableDefinitionImpl
implements TableDefinition {
    private final String tableName;
    private final String tableNameAndColumnDefinitions;
    private final List<String> columnNames;
    private final String createTableStatement;
    private final String dropTableStatement;
    private final List<String> createIndexStatements;

    public TableDefinitionImpl(String tableName, String tableSchema, List<String> columnNames, String createTableStatement, String dropTableStatement, List<String> createIndexStatements) {
        this.tableName = tableName;
        this.tableNameAndColumnDefinitions = tableSchema;
        this.columnNames = Collections.unmodifiableList(columnNames);
        this.createTableStatement = createTableStatement;
        this.dropTableStatement = dropTableStatement;
        this.createIndexStatements = Collections.unmodifiableList(createIndexStatements);
    }

    public String toString() {
        return "TableDefinition [tableName=" + this.tableName + ", tableNameAndColumnDefinitions=" + this.tableNameAndColumnDefinitions + ", columnNames=" + String.valueOf(this.columnNames) + ", createTableStatement=" + this.createTableStatement + ", dropTableStatement=" + this.dropTableStatement + ", createIndexStatements=" + String.valueOf(this.createIndexStatements) + "]";
    }

    @Override
    public TableDefinition createIndexesIfNotExists(Orm orm) {
        this.getCreateIndexIfNotExistsStatements().forEach(s -> orm.executeUpdate((String)s, new Object[0]));
        return this;
    }

    @Override
    public TableDefinition createTableIfNotExists(Orm orm) {
        orm.executeUpdate(this.getCreateTableIfNotExistsStatement(), new Object[0]);
        return this;
    }

    @Override
    public TableDefinition dropTableIfExists(Orm orm) {
        orm.executeUpdate(this.getDropTableIfExistsStatement(), new Object[0]);
        return this;
    }

    @Override
    public void dropTableIfExistsCascade(Orm orm) {
        orm.executeUpdate(this.getDropTableIfExistsStatement() + " cascade", new Object[0]);
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public List<String> getCreateIndexIfNotExistsStatements() {
        return this.createIndexStatements;
    }

    @Override
    public String getCreateTableIfNotExistsStatement() {
        return this.createTableStatement;
    }

    @Override
    public String getDropTableIfExistsStatement() {
        return this.dropTableStatement;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getTableNameAndColumnDefinitions() {
        return this.tableNameAndColumnDefinitions;
    }
}

