/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nkjmlab.sorm4j.internal.util.ClassUtils;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public final class ArrayUtils {
    private static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    private static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    private static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    private static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    private static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    private static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    private static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    private static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];

    private ArrayUtils() {
    }

    public static int[] add(int[] array, int i) {
        int arrayLength = Array.getLength(array);
        int[] newArray = new int[arrayLength + 1];
        System.arraycopy(array, 0, newArray, 0, arrayLength);
        newArray[arrayLength] = i;
        return newArray;
    }

    @SafeVarargs
    public static <T> List<T[]> split(int size, T ... objects) {
        int slotNum = Math.floorDiv(objects.length, size);
        ArrayList<T[]> result = new ArrayList<T[]>(slotNum + 1);
        for (int i = 0; i < slotNum; ++i) {
            result.add(Arrays.copyOfRange(objects, size * i, size * (i + 1)));
        }
        if (size * slotNum != objects.length) {
            result.add(Arrays.copyOfRange(objects, size * slotNum, objects.length));
        }
        return result;
    }

    public static Boolean[] toObjectArray(boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Byte[] toObjectArray(byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Character[] toObjectArray(char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Character.valueOf(array[i]);
        }
        return result;
    }

    public static Double[] toObjectArray(double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Float[] toObjectArray(float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public static Integer[] toObjectArray(int[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Long[] toObjectArray(long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Short[] toObjectArray(short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Object convertSqlArrayToArray(Class<?> toComponentType, java.sql.Array srcArray) {
        return ArrayUtils.convertSqlArrayToArrayAux(toComponentType, srcArray);
    }

    private static Object convertSqlArrayToArrayAux(Class<?> toComponentType, Object srcArray) {
        if (srcArray == null) {
            return null;
        }
        if (srcArray instanceof java.sql.Array) {
            try {
                java.sql.Array sqlArray = (java.sql.Array)srcArray;
                Object array = sqlArray.getArray();
                return ArrayUtils.convertSqlArrayToArrayAux(toComponentType, array);
            }
            catch (SQLException e) {
                throw Try.rethrow(e);
            }
        }
        if (toComponentType.isArray()) {
            int length = Array.getLength(srcArray);
            Class<?> compArrType = toComponentType.getComponentType();
            Object destArray = Array.newInstance(toComponentType, length);
            for (int i = 0; i < length; ++i) {
                Object v = Array.get(srcArray, i);
                Array.set(destArray, i, ArrayUtils.convertSqlArrayToArrayAux(compArrType, v));
            }
            return destArray;
        }
        int length = Array.getLength(srcArray);
        Object destArray = Array.newInstance(toComponentType, length);
        for (int i = 0; i < length; ++i) {
            Object v = Array.get(srcArray, i);
            Array.set(destArray, i, v);
        }
        return destArray;
    }

    public static <T> T[] convertToObjectArray(Class<T> componentType, Object srcArray) {
        if (srcArray == null) {
            return null;
        }
        int length = Array.getLength(srcArray);
        Object destArray = Array.newInstance(componentType.isPrimitive() ? ClassUtils.primitiveToWrapper(componentType) : componentType, length);
        for (int i = 0; i < length; ++i) {
            Object v = Array.get(srcArray, i);
            Array.set(destArray, i, v);
        }
        Object[] ret = (Object[])destArray;
        return ret;
    }

    public static Object[] convertToObjectArray(Object srcArray) {
        if (srcArray == null) {
            return null;
        }
        Class<?> componentType = srcArray.getClass().getComponentType();
        if (componentType == null) {
            throw new IllegalArgumentException("the argument could not be convert to an object array.");
        }
        if (!componentType.isArray()) {
            switch (srcArray.getClass().getComponentType().toString()) {
                case "boolean": {
                    return ArrayUtils.toObjectArray((boolean[])srcArray);
                }
                case "byte": {
                    return ArrayUtils.toObjectArray((byte[])srcArray);
                }
                case "char": {
                    return ArrayUtils.toObjectArray((char[])srcArray);
                }
                case "short": {
                    return ArrayUtils.toObjectArray((short[])srcArray);
                }
                case "int": {
                    return ArrayUtils.toObjectArray((int[])srcArray);
                }
                case "long": {
                    return ArrayUtils.toObjectArray((long[])srcArray);
                }
                case "float": {
                    return ArrayUtils.toObjectArray((float[])srcArray);
                }
                case "double": {
                    return ArrayUtils.toObjectArray((double[])srcArray);
                }
            }
            return (Object[])srcArray;
        }
        Object o = Array.get(srcArray, 0);
        int length = Array.getLength(srcArray);
        Object destArray = Array.newInstance(Array.newInstance(ArrayUtils.convertToObjectArray(o).getClass().getComponentType(), 0).getClass(), length);
        for (int i = 0; i < length; ++i) {
            Object v = Array.get(srcArray, i);
            Array.set(destArray, i, ArrayUtils.convertToObjectArray(v));
        }
        return (Object[])destArray;
    }

    public static Class<?> getInternalComponentType(Class<?> compType) {
        Class<?> ret = compType;
        while (ret.isArray()) {
            ret = ret.getComponentType();
        }
        return ret;
    }
}

