/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public final class CanonicalStringCache {
    private final Map<String, String> cache;
    private final String tableAndColumnSeparator;
    public static final CanonicalStringCache DEFAULT = new CanonicalStringCache(new ConcurrentHashMap<String, String>(), "_DOT_");
    private static final Pattern INVALID_CHAR_PATTERN = Pattern.compile("[^\\p{L}\\p{N}]+");
    private static final Pattern LAST_UNDERSCORE_PATTERN = Pattern.compile("_+$");
    private static final Pattern MULTI_UNDERSCORES_PATTERN = Pattern.compile("_{2,}");

    public static CanonicalStringCache getDefault() {
        return DEFAULT;
    }

    public CanonicalStringCache(Map<String, String> map, String tableAndColumnSeparator) {
        this.cache = map;
        this.tableAndColumnSeparator = tableAndColumnSeparator;
    }

    public String toCanonicalName(String name) {
        return this.cache.computeIfAbsent(name, key -> CanonicalStringCache.canonicalize(name));
    }

    public static String canonicalize(String name) {
        return CanonicalStringCache.toUpperSnakeCase(CanonicalStringCache.replaceInvalidCharacters(name));
    }

    private static String toUpperSnakeCase(String name) {
        if (name.indexOf(95) >= 0 || CanonicalStringCache.containsJapanese(name)) {
            return name.toUpperCase(Locale.ENGLISH);
        }
        return name.replaceAll("([a-z0-9])([A-Z])", "$1_$2").replaceAll("([A-Z])([A-Z][a-z])", "$1_$2").toUpperCase(Locale.ENGLISH);
    }

    private static boolean containsJapanese(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.UnicodeBlock.of(text.charAt(i)) != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) continue;
            return true;
        }
        return false;
    }

    public static String replaceInvalidCharacters(String name) {
        return LAST_UNDERSCORE_PATTERN.matcher(MULTI_UNDERSCORES_PATTERN.matcher(INVALID_CHAR_PATTERN.matcher(name).replaceAll("_")).replaceAll("")).replaceAll("");
    }

    public String toCanonicalNameWithTableName(String tableName, String columnName) {
        return this.toCanonicalName(tableName) + this.tableAndColumnSeparator + this.toCanonicalName(columnName);
    }

    public boolean containsCanonicalName(Collection<String> collection, String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return collection.stream().anyMatch(e -> this.equalsCanonicalName((String)e, name));
    }

    public boolean equalsCanonicalName(String name, String other) {
        return this.toCanonicalName(name).equals(this.toCanonicalName(other));
    }

    public String toString() {
        return this.cache.toString();
    }

    public Map<String, String> getCache() {
        return this.cache;
    }
}

