/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.Arrays;
import java.util.function.Function;

public final class ParameterizedStringFormatter {
    private static final String DEFAULT_PLACEHOLDER = "{}";
    public static final ParameterizedStringFormatter LENGTH_8 = new ParameterizedStringFormatter("{}", 8);
    public static final ParameterizedStringFormatter LENGTH_16 = new ParameterizedStringFormatter("{}", 16);
    public static final ParameterizedStringFormatter LENGTH_32 = new ParameterizedStringFormatter("{}", 32);
    public static final ParameterizedStringFormatter LENGTH_64 = new ParameterizedStringFormatter("{}", 64);
    public static final ParameterizedStringFormatter LENGTH_128 = new ParameterizedStringFormatter("{}", 128);
    public static final ParameterizedStringFormatter LENGTH_256 = new ParameterizedStringFormatter("{}", 256);
    public static final ParameterizedStringFormatter LENGTH_512 = new ParameterizedStringFormatter("{}", 512);
    public static final ParameterizedStringFormatter LENGTH_1024 = new ParameterizedStringFormatter("{}", 1024);
    public static final ParameterizedStringFormatter NO_LENGTH_LIMIT;
    public static final ParameterizedStringFormatter DEFAULT;
    private final String placeholder;
    private final int maxLength;

    private ParameterizedStringFormatter(int maxLength) {
        this(DEFAULT_PLACEHOLDER, maxLength);
    }

    private ParameterizedStringFormatter(String placeholder, int maxLength) {
        this.placeholder = placeholder;
        this.maxLength = maxLength;
    }

    public String format(String msg, Object ... params) {
        return ParameterizedStringFormatter.newStringWithPlaceHolder(msg, this.placeholder, this.maxLength, params);
    }

    private static String newStringWithPlaceHolder(String msg, String placeholder, int maxLength, Object ... params) {
        if (params == null || params.length == 0) {
            return msg;
        }
        return ParameterizedStringFormatter.newString(msg, placeholder, params.length, index -> ParameterizedStringFormatter.toString(maxLength, params[index]));
    }

    private static String trim(String string, int maxLength) {
        if (string.length() <= maxLength) {
            return string;
        }
        return string.substring(0, maxLength) + "...";
    }

    public static String newString(String msg, String placeholder, int numOfParameter, Function<Integer, String> parameterReplacer) {
        int j;
        StringBuilder sbuf = new StringBuilder(msg.length() + 50);
        int i = 0;
        int placeholderStringLength = placeholder.length();
        for (int p = 0; p < numOfParameter && (j = msg.indexOf(placeholder, i)) != -1; ++p) {
            sbuf.append(msg, i, j);
            sbuf.append(parameterReplacer.apply(p));
            i = j + placeholderStringLength;
        }
        sbuf.append(msg, i, msg.length());
        return sbuf.toString();
    }

    private static String toString(int maxLength, Object param) {
        if (param == null) {
            return "null";
        }
        if (param.getClass().isArray()) {
            String s = Arrays.deepToString(new Object[]{param});
            return ParameterizedStringFormatter.trim(s.substring(1, s.length()), maxLength);
        }
        return ParameterizedStringFormatter.trim(param.toString(), maxLength);
    }

    static {
        DEFAULT = NO_LENGTH_LIMIT = new ParameterizedStringFormatter(DEFAULT_PLACEHOLDER, Integer.MAX_VALUE);
    }
}

