/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class SystemPropertyUtils {
    private SystemPropertyUtils() {
    }

    static Path getUserHomeDirectory() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    public static Path getTempDir() {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    public static Path convertVariableInPath(Path path) {
        Map<String, Path> replaceStringMap = Map.of("%TEMP%", SystemPropertyUtils.getTempDir(), "$TMPDIR", SystemPropertyUtils.getTempDir(), "%USERPROFILE%", SystemPropertyUtils.getUserHomeDirectory(), "~", SystemPropertyUtils.getUserHomeDirectory());
        String pathStr = path.toString();
        for (Map.Entry<String, Path> entry : replaceStringMap.entrySet()) {
            if (!pathStr.startsWith(entry.getKey())) continue;
            return entry.getValue().resolve(SystemPropertyUtils.stripLeadingSeparator(pathStr.substring(entry.getKey().length())));
        }
        return path;
    }

    private static String stripLeadingSeparator(String pathStr) {
        return pathStr.replaceFirst("^[\\\\/]+", "");
    }
}

