/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Optional;
import org.nkjmlab.sorm4j.internal.util.reflection.RefrectionOrmComponentUtils;
import org.nkjmlab.sorm4j.mapping.annotation.OrmConstructor;
import org.nkjmlab.sorm4j.mapping.annotation.OrmIgnore;
import org.nkjmlab.sorm4j.mapping.annotation.OrmRecordCompatibleConstructor;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public class ReflectionConstrucorsUtils {
    public static <T> OrmConstructorDefinition<T> createOrmConstructorDefinition(Class<T> objectClass) {
        Class<T> rc;
        Constructor<T> recordConstructor;
        Constructor<T> ormConstructor = ReflectionConstrucorsUtils.getAnnotatedOrmConstructor(objectClass);
        if (ormConstructor != null) {
            return new OrmConstructorDefinition<T>(ormConstructor, ReflectionConstrucorsUtils.toOrmConstructorParameterNames(ormConstructor));
        }
        Constructor<T> ormRocordCompatibleConstructor = ReflectionConstrucorsUtils.getOrmRecordCompatibleConstructor(objectClass);
        if (ormRocordCompatibleConstructor != null) {
            return new OrmConstructorDefinition<T>(ormRocordCompatibleConstructor, ReflectionConstrucorsUtils.toOrmRecordCompatibleConstructorParameterNames(objectClass));
        }
        if (objectClass.isRecord() && (recordConstructor = ReflectionConstrucorsUtils.getRecordConstructor(rc = objectClass)) != null) {
            return new OrmConstructorDefinition<T>(recordConstructor, ReflectionConstrucorsUtils.toRecordConstructorParameterNames(rc));
        }
        return null;
    }

    private static <T> Constructor<T> getAnnotatedOrmConstructor(Class<T> valueType) {
        return ReflectionConstrucorsUtils.getConstructorByAnnotation(valueType, OrmConstructor.class);
    }

    private static <T> Constructor<T> getConstructorByAnnotation(Class<T> valueType, Class<? extends Annotation> annotationClass) {
        return Arrays.stream(valueType.getConstructors()).filter(c -> c.isAnnotationPresent(annotationClass) && !c.isAnnotationPresent(OrmIgnore.class)).findFirst().orElse(null);
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> valueType) {
        return Try.getOrElseNull(() -> valueType.getConstructor(new Class[0]));
    }

    private static <T> Constructor<T> getOrmRecordCompatibleConstructor(Class<T> valueType) {
        return ReflectionConstrucorsUtils.getConstructorByAnnotation(valueType, OrmRecordCompatibleConstructor.class);
    }

    public static <T> Optional<Constructor<T>> getRecordCanonicalConstructor(Class<T> valueType) {
        return valueType.isRecord() ? Optional.of(ReflectionConstrucorsUtils.getRecordConstructor(valueType)) : Optional.ofNullable(ReflectionConstrucorsUtils.getOrmRecordCompatibleConstructor(valueType));
    }

    private static <T extends Record> Constructor<T> getRecordConstructor(Class<T> valueType) {
        try {
            Class[] paramTypes = (Class[])RefrectionOrmComponentUtils.getRecordComponents(valueType).stream().map(RecordComponent::getType).toArray(Class[]::new);
            Constructor<T> constructor = valueType.getDeclaredConstructor(paramTypes);
            return constructor.isAnnotationPresent(OrmIgnore.class) ? null : constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static String[] toOrmConstructorParameterNames(Constructor<?> constructor) {
        return constructor.getAnnotation(OrmConstructor.class).value();
    }

    private static String[] toOrmRecordCompatibleConstructorParameterNames(Class<?> valueType) {
        return (String[])RefrectionOrmComponentUtils.getDeclaredFields(valueType).stream().map(f -> f.getName()).toArray(String[]::new);
    }

    private static <T extends Record> String[] toRecordConstructorParameterNames(Class<T> valueType) {
        return (String[])RefrectionOrmComponentUtils.getRecordComponents(valueType).stream().map(RecordComponent::getName).toArray(String[]::new);
    }

    private ReflectionConstrucorsUtils() {
    }

    public record OrmConstructorDefinition<T>(Constructor<T> constructor, String[] parameterNames) {
    }
}

